/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import io.a2a.spec.Part;
import io.a2a.util.Assert;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public record Artifact(String artifactId, @Nullable String name, @Nullable String description, List<Part<?>> parts, @Nullable Map<String, Object> metadata, @Nullable List<String> extensions) {
    public Artifact(String artifactId, @Nullable String name, @Nullable String description, List<Part<?>> parts, @Nullable Map<String, Object> metadata, @Nullable List<String> extensions) {
        Assert.checkNotNullParam((String)"artifactId", (Object)artifactId);
        Assert.checkNotNullParam((String)"parts", parts);
        if (parts.isEmpty()) {
            throw new IllegalArgumentException("Parts cannot be empty");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Artifact artifact) {
        return new Builder(artifact);
    }

    public static class Builder {
        private @Nullable String artifactId;
        private @Nullable String name;
        private @Nullable String description;
        private @Nullable List<Part<?>> parts;
        private @Nullable Map<String, Object> metadata;
        private @Nullable List<String> extensions;

        private Builder() {
        }

        private Builder(Artifact existingArtifact) {
            this.artifactId = existingArtifact.artifactId;
            this.name = existingArtifact.name;
            this.description = existingArtifact.description;
            this.parts = existingArtifact.parts;
            this.metadata = existingArtifact.metadata;
            this.extensions = existingArtifact.extensions;
        }

        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public Builder parts(List<Part<?>> parts) {
            this.parts = parts;
            return this;
        }

        public Builder parts(Part<?> ... parts) {
            this.parts = List.of(parts);
            return this;
        }

        public Builder metadata(@Nullable Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder extensions(@Nullable List<String> extensions) {
            this.extensions = extensions == null ? null : List.copyOf(extensions);
            return this;
        }

        public Artifact build() {
            return new Artifact((String)Assert.checkNotNullParam((String)"artifactId", (Object)this.artifactId), this.name, this.description, (List)Assert.checkNotNullParam((String)"parts", this.parts), this.metadata, this.extensions);
        }
    }
}

