/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import com.google.gson.annotations.SerializedName;
import io.a2a.spec.EventKind;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.TaskStatus;
import io.a2a.spec.UpdateEvent;
import io.a2a.util.Assert;
import java.util.Map;

public record TaskStatusUpdateEvent(String taskId, TaskStatus status, String contextId, @SerializedName(value="final") boolean isFinal, Map<String, Object> metadata) implements EventKind,
StreamingEventKind,
UpdateEvent
{
    public static final String STREAMING_EVENT_ID = "statusUpdate";

    public TaskStatusUpdateEvent {
        Assert.checkNotNullParam((String)"taskId", (Object)taskId);
        Assert.checkNotNullParam((String)"status", (Object)status);
        Assert.checkNotNullParam((String)"contextId", (Object)contextId);
    }

    @Override
    public String kind() {
        return STREAMING_EVENT_ID;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TaskStatusUpdateEvent event) {
        return new Builder(event);
    }

    public static class Builder {
        private String taskId;
        private TaskStatus status;
        private String contextId;
        private boolean isFinal;
        private Map<String, Object> metadata;

        private Builder() {
        }

        private Builder(TaskStatusUpdateEvent existingTaskStatusUpdateEvent) {
            this.taskId = existingTaskStatusUpdateEvent.taskId;
            this.status = existingTaskStatusUpdateEvent.status;
            this.contextId = existingTaskStatusUpdateEvent.contextId;
            this.isFinal = existingTaskStatusUpdateEvent.isFinal;
            this.metadata = existingTaskStatusUpdateEvent.metadata;
        }

        public Builder taskId(String id) {
            this.taskId = id;
            return this;
        }

        public Builder status(TaskStatus status) {
            this.status = status;
            return this;
        }

        public Builder contextId(String contextId) {
            this.contextId = contextId;
            return this;
        }

        public Builder isFinal(boolean isFinal) {
            this.isFinal = isFinal;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public TaskStatusUpdateEvent build() {
            return new TaskStatusUpdateEvent(this.taskId, this.status, this.contextId, this.isFinal, this.metadata);
        }
    }
}

