/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import io.a2a.spec.Artifact;
import io.a2a.spec.EventKind;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.UpdateEvent;
import io.a2a.util.Assert;
import java.util.Map;

public record TaskArtifactUpdateEvent(String taskId, Artifact artifact, String contextId, Boolean append, Boolean lastChunk, Map<String, Object> metadata) implements EventKind,
StreamingEventKind,
UpdateEvent
{
    public static final String STREAMING_EVENT_ID = "artifactUpdate";

    public TaskArtifactUpdateEvent {
        Assert.checkNotNullParam((String)"taskId", (Object)taskId);
        Assert.checkNotNullParam((String)"artifact", (Object)artifact);
        Assert.checkNotNullParam((String)"contextId", (Object)contextId);
    }

    @Override
    public String kind() {
        return STREAMING_EVENT_ID;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TaskArtifactUpdateEvent event) {
        return new Builder(event);
    }

    public static class Builder {
        private String taskId;
        private Artifact artifact;
        private String contextId;
        private Boolean append;
        private Boolean lastChunk;
        private Map<String, Object> metadata;

        private Builder() {
        }

        private Builder(TaskArtifactUpdateEvent existingTaskArtifactUpdateEvent) {
            this.taskId = existingTaskArtifactUpdateEvent.taskId;
            this.artifact = existingTaskArtifactUpdateEvent.artifact;
            this.contextId = existingTaskArtifactUpdateEvent.contextId;
            this.append = existingTaskArtifactUpdateEvent.append;
            this.lastChunk = existingTaskArtifactUpdateEvent.lastChunk;
            this.metadata = existingTaskArtifactUpdateEvent.metadata;
        }

        public Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder artifact(Artifact artifact) {
            this.artifact = artifact;
            return this;
        }

        public Builder contextId(String contextId) {
            this.contextId = contextId;
            return this;
        }

        public Builder append(Boolean append) {
            this.append = append;
            return this;
        }

        public Builder lastChunk(Boolean lastChunk) {
            this.lastChunk = lastChunk;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public TaskArtifactUpdateEvent build() {
            return new TaskArtifactUpdateEvent(this.taskId, this.artifact, this.contextId, this.append, this.lastChunk, this.metadata);
        }
    }
}

