/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.a2a.spec.EventKind;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.TaskStatus;
import io.a2a.spec.UpdateEvent;
import io.a2a.util.Assert;
import java.util.Map;

@JsonTypeName(value="status-update")
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class TaskStatusUpdateEvent
implements EventKind,
StreamingEventKind,
UpdateEvent {
    public static final String STATUS_UPDATE = "status-update";
    private final String taskId;
    private final TaskStatus status;
    private final String contextId;
    private final boolean isFinal;
    private final Map<String, Object> metadata;
    private final String kind;

    public TaskStatusUpdateEvent(String taskId, TaskStatus status, String contextId, boolean isFinal, Map<String, Object> metadata) {
        this(taskId, status, contextId, isFinal, metadata, STATUS_UPDATE);
    }

    @JsonCreator
    public TaskStatusUpdateEvent(@JsonProperty(value="taskId") String taskId, @JsonProperty(value="status") TaskStatus status, @JsonProperty(value="contextId") String contextId, @JsonProperty(value="final") boolean isFinal, @JsonProperty(value="metadata") Map<String, Object> metadata, @JsonProperty(value="kind") String kind) {
        Assert.checkNotNullParam((String)"taskId", (Object)taskId);
        Assert.checkNotNullParam((String)"status", (Object)status);
        Assert.checkNotNullParam((String)"contextId", (Object)contextId);
        Assert.checkNotNullParam((String)"kind", (Object)kind);
        if (!kind.equals(STATUS_UPDATE)) {
            throw new IllegalArgumentException("Invalid TaskStatusUpdateEvent");
        }
        this.taskId = taskId;
        this.status = status;
        this.contextId = contextId;
        this.isFinal = isFinal;
        this.metadata = metadata;
        this.kind = kind;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public TaskStatus getStatus() {
        return this.status;
    }

    public String getContextId() {
        return this.contextId;
    }

    @JsonProperty(value="final")
    public boolean isFinal() {
        return this.isFinal;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    public static class Builder {
        private String taskId;
        private TaskStatus status;
        private String contextId;
        private boolean isFinal;
        private Map<String, Object> metadata;

        public Builder taskId(String id) {
            this.taskId = id;
            return this;
        }

        public Builder status(TaskStatus status) {
            this.status = status;
            return this;
        }

        public Builder contextId(String contextId) {
            this.contextId = contextId;
            return this;
        }

        public Builder isFinal(boolean isFinal) {
            this.isFinal = isFinal;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public TaskStatusUpdateEvent build() {
            return new TaskStatusUpdateEvent(this.taskId, this.status, this.contextId, this.isFinal, this.metadata);
        }
    }
}

