/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.a2a.spec.FileContent;
import io.a2a.spec.FileWithBytes;
import io.a2a.spec.FileWithUri;
import java.io.IOException;

public class FileContentDeserializer
extends StdDeserializer<FileContent> {
    public FileContentDeserializer() {
        this(null);
    }

    public FileContentDeserializer(Class<?> vc) {
        super(vc);
    }

    public FileContent deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        JsonNode mimeType = node.get("mimeType");
        JsonNode name = node.get("name");
        JsonNode bytes = node.get("bytes");
        if (bytes != null) {
            return new FileWithBytes(mimeType != null ? mimeType.asText() : null, name != null ? name.asText() : null, bytes.asText());
        }
        if (node.has("uri")) {
            return new FileWithUri(mimeType != null ? mimeType.asText() : null, name != null ? name.asText() : null, node.get("uri").asText());
        }
        throw new IOException("Invalid file format: missing 'bytes' or 'uri'");
    }
}

