/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.spec;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.a2a.spec.Artifact;
import io.a2a.spec.EventKind;
import io.a2a.spec.StreamingEventKind;
import io.a2a.util.Assert;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class TaskArtifactUpdateEvent
implements EventKind,
StreamingEventKind {
    public static final String ARTIFACT_UPDATE = "artifact-update";
    private final String taskId;
    private final Boolean append;
    private final Boolean lastChunk;
    private final Artifact artifact;
    private final String contextId;
    private final Map<String, Object> metadata;
    private final String kind;

    public TaskArtifactUpdateEvent(String taskId, Artifact artifact, String contextId, Boolean append, Boolean lastChunk, Map<String, Object> metadata) {
        this(taskId, artifact, contextId, append, lastChunk, metadata, ARTIFACT_UPDATE);
    }

    @JsonCreator
    public TaskArtifactUpdateEvent(@JsonProperty(value="taskId") String taskId, @JsonProperty(value="artifact") Artifact artifact, @JsonProperty(value="contextId") String contextId, @JsonProperty(value="append") Boolean append, @JsonProperty(value="lastChunk") Boolean lastChunk, @JsonProperty(value="metadata") Map<String, Object> metadata, @JsonProperty(value="kind") String kind) {
        Assert.checkNotNullParam((String)"taskId", (Object)taskId);
        Assert.checkNotNullParam((String)"artifact", (Object)artifact);
        Assert.checkNotNullParam((String)"contextId", (Object)contextId);
        Assert.checkNotNullParam((String)"kind", (Object)kind);
        if (!kind.equals(ARTIFACT_UPDATE)) {
            throw new IllegalArgumentException("Invalid TaskArtifactUpdateEvent");
        }
        this.taskId = taskId;
        this.artifact = artifact;
        this.contextId = contextId;
        this.append = append;
        this.lastChunk = lastChunk;
        this.metadata = metadata;
        this.kind = kind;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public String getContextId() {
        return this.contextId;
    }

    public Boolean isAppend() {
        return this.append;
    }

    public Boolean isLastChunk() {
        return this.lastChunk;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    public static class Builder {
        private String taskId;
        private Artifact artifact;
        private String contextId;
        private Boolean append;
        private Boolean lastChunk;
        private Map<String, Object> metadata;

        public Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder artifact(Artifact artifact) {
            this.artifact = artifact;
            return this;
        }

        public Builder contextId(String contextId) {
            this.contextId = contextId;
            return this;
        }

        public Builder append(Boolean append) {
            this.append = append;
            return this;
        }

        public Builder lastChunk(Boolean lastChunk) {
            this.lastChunk = lastChunk;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public TaskArtifactUpdateEvent build() {
            return new TaskArtifactUpdateEvent(this.taskId, this.artifact, this.contextId, this.append, this.lastChunk, this.metadata);
        }
    }
}

