/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.tasks;

import io.a2a.server.agentexecution.RequestContext;
import io.a2a.server.events.EventQueue;
import io.a2a.spec.A2AError;
import io.a2a.spec.Artifact;
import io.a2a.spec.Event;
import io.a2a.spec.Message;
import io.a2a.spec.Part;
import io.a2a.spec.Task;
import io.a2a.spec.TaskArtifactUpdateEvent;
import io.a2a.spec.TaskState;
import io.a2a.spec.TaskStatus;
import io.a2a.spec.TaskStatusUpdateEvent;
import io.a2a.spec.TextPart;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jspecify.annotations.Nullable;

public class AgentEmitter {
    private final EventQueue eventQueue;
    private final String taskId;
    private final String contextId;
    private final AtomicBoolean terminalStateReached = new AtomicBoolean(false);

    public AgentEmitter(RequestContext context, EventQueue eventQueue) {
        this.eventQueue = eventQueue;
        this.taskId = context.getTaskId();
        this.contextId = context.getContextId();
    }

    private void updateStatus(TaskState taskState) {
        this.updateStatus(taskState, null, taskState.isFinal());
    }

    public void updateStatus(TaskState taskState, @Nullable Message message) {
        this.updateStatus(taskState, message, taskState.isFinal());
    }

    private void updateStatus(TaskState state, @Nullable Message message, boolean isFinal) {
        if (this.terminalStateReached.get()) {
            throw new IllegalStateException("Cannot update task status - terminal state already reached");
        }
        if (isFinal && !this.terminalStateReached.compareAndSet(false, true)) {
            throw new IllegalStateException("Cannot update task status - terminal state already reached");
        }
        TaskStatusUpdateEvent event = TaskStatusUpdateEvent.builder().taskId(this.taskId).contextId(this.contextId).status(new TaskStatus(state, message, null)).build();
        this.eventQueue.enqueueEvent((Event)event);
    }

    public @Nullable String getContextId() {
        return this.contextId;
    }

    public @Nullable String getTaskId() {
        return this.taskId;
    }

    public void addArtifact(List<Part<?>> parts) {
        this.addArtifact(parts, null, null, null);
    }

    public void addArtifact(List<Part<?>> parts, @Nullable String artifactId, @Nullable String name, @Nullable Map<String, Object> metadata) {
        this.addArtifact(parts, artifactId, name, metadata, null, null);
    }

    public void addArtifact(List<Part<?>> parts, @Nullable String artifactId, @Nullable String name, @Nullable Map<String, Object> metadata, @Nullable Boolean append, @Nullable Boolean lastChunk) {
        if (artifactId == null) {
            artifactId = UUID.randomUUID().toString();
        }
        TaskArtifactUpdateEvent event = TaskArtifactUpdateEvent.builder().taskId(this.taskId).contextId(this.contextId).artifact(Artifact.builder().artifactId(artifactId).name(name).parts(parts).metadata(metadata).build()).append(append).lastChunk(lastChunk).build();
        this.eventQueue.enqueueEvent((Event)event);
    }

    public void complete() {
        this.complete(null);
    }

    public void complete(@Nullable Message message) {
        this.updateStatus(TaskState.TASK_STATE_COMPLETED, message);
    }

    public void fail() {
        this.fail((Message)null);
    }

    public void fail(@Nullable Message message) {
        this.updateStatus(TaskState.TASK_STATE_FAILED, message);
    }

    public void fail(A2AError error) {
        if (!this.terminalStateReached.compareAndSet(false, true)) {
            throw new IllegalStateException("Cannot update task status - terminal state already reached");
        }
        this.eventQueue.enqueueEvent((Event)error);
    }

    public void submit() {
        this.submit(null);
    }

    public void submit(@Nullable Message message) {
        this.updateStatus(TaskState.TASK_STATE_SUBMITTED, message);
    }

    public void startWork() {
        this.startWork(null);
    }

    public void startWork(@Nullable Message message) {
        this.updateStatus(TaskState.TASK_STATE_WORKING, message);
    }

    public void cancel() {
        this.cancel(null);
    }

    public void cancel(@Nullable Message message) {
        this.updateStatus(TaskState.TASK_STATE_CANCELED, message);
    }

    public void reject() {
        this.reject(null);
    }

    public void reject(@Nullable Message message) {
        this.updateStatus(TaskState.TASK_STATE_REJECTED, message);
    }

    public void requiresInput() {
        this.requiresInput(null, false);
    }

    public void requiresInput(@Nullable Message message) {
        this.requiresInput(message, false);
    }

    public void requiresInput(boolean isFinal) {
        this.requiresInput(null, isFinal);
    }

    public void requiresInput(@Nullable Message message, boolean isFinal) {
        this.updateStatus(TaskState.TASK_STATE_INPUT_REQUIRED, message, isFinal);
    }

    public void requiresAuth() {
        this.requiresAuth(null, false);
    }

    public void requiresAuth(@Nullable Message message) {
        this.requiresAuth(message, false);
    }

    public void requiresAuth(boolean isFinal) {
        this.requiresAuth(null, isFinal);
    }

    public void requiresAuth(@Nullable Message message, boolean isFinal) {
        this.updateStatus(TaskState.TASK_STATE_AUTH_REQUIRED, message, isFinal);
    }

    public Message newAgentMessage(List<Part<?>> parts, @Nullable Map<String, Object> metadata) {
        return Message.builder().role(Message.Role.ROLE_AGENT).taskId(this.taskId).contextId(this.contextId).messageId(UUID.randomUUID().toString()).metadata(metadata).parts(parts).build();
    }

    public void sendMessage(String text) {
        this.sendMessage(List.of(new TextPart(text)));
    }

    public void sendMessage(List<Part<?>> parts) {
        this.sendMessage(parts, null);
    }

    public void sendMessage(List<Part<?>> parts, @Nullable Map<String, Object> metadata) {
        Message message = this.newAgentMessage(parts, metadata);
        this.eventQueue.enqueueEvent((Event)message);
    }

    public void sendMessage(Message message) {
        this.eventQueue.enqueueEvent((Event)message);
    }

    public void addTask(Task task) {
        this.eventQueue.enqueueEvent((Event)task);
    }

    public void emitEvent(Event event) {
        this.eventQueue.enqueueEvent(event);
    }

    public Task.Builder taskBuilder() {
        return Task.builder().id(this.taskId).contextId(this.contextId);
    }

    public Message.Builder messageBuilder() {
        Message.Builder builder = Message.builder().contextId(this.contextId).role(Message.Role.ROLE_AGENT).messageId(UUID.randomUUID().toString());
        if (this.taskId != null) {
            builder.taskId(this.taskId);
        }
        return builder;
    }
}

