/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.config;

import io.a2a.server.config.A2AConfigProvider;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultValuesConfigProvider
implements A2AConfigProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultValuesConfigProvider.class);
    private static final String DEFAULTS_RESOURCE = "META-INF/a2a-defaults.properties";
    private final Map<String, String> defaults = new HashMap<String, String>();

    @PostConstruct
    void init() {
        this.loadDefaultsFromClasspath();
    }

    private void loadDefaultsFromClasspath() {
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(DEFAULTS_RESOURCE);
            HashMap<String, String> sourceTracker = new HashMap<String, String>();
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                LOGGER.debug("Loading A2A defaults from: {}", (Object)url);
                Properties props = new Properties();
                InputStream is = url.openStream();
                try {
                    props.load(is);
                    for (String key : props.stringPropertyNames()) {
                        String value = props.getProperty(key);
                        String existingSource = (String)sourceTracker.get(key);
                        if (existingSource != null) {
                            throw new IllegalStateException(String.format("Duplicate configuration key '%s' found in multiple a2a-defaults.properties files: %s and %s", key, existingSource, url));
                        }
                        this.defaults.put(key, value);
                        sourceTracker.put(key, url.toString());
                        LOGGER.trace("Loaded default: {} = {}", (Object)key, (Object)value);
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            LOGGER.info("Loaded {} A2A default configuration values from {} resource(s)", (Object)this.defaults.size(), (Object)sourceTracker.values().stream().distinct().count());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load A2A default configuration from classpath", e);
        }
    }

    @Override
    public String getValue(String name) {
        String value = this.defaults.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No default configuration value found for: " + name);
        }
        return value;
    }

    @Override
    public Optional<String> getOptionalValue(String name) {
        return Optional.ofNullable(this.defaults.get(name));
    }
}

