/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.util.async;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Qualifier;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class EventConsumerExecutorProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventConsumerExecutorProducer.class);
    private @Nullable ExecutorService executor;

    @Produces
    @EventConsumerExecutor
    @ApplicationScoped
    public Executor eventConsumerExecutor() {
        this.executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new EventConsumerThreadFactory());
        LOGGER.info("Initialized EventConsumer executor: cached thread pool (unbounded, 10s idle timeout)");
        return this.executor;
    }

    private static class EventConsumerThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        private EventConsumerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "a2a-event-consumer-" + this.threadNumber.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.TYPE})
    @Qualifier
    public static @interface EventConsumerExecutor {
    }
}

