/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.util.async;

import io.a2a.server.config.A2AConfigProvider;
import io.a2a.server.util.async.Internal;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class AsyncExecutorProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncExecutorProducer.class);
    private static final String A2A_EXECUTOR_CORE_POOL_SIZE = "a2a.executor.core-pool-size";
    private static final String A2A_EXECUTOR_MAX_POOL_SIZE = "a2a.executor.max-pool-size";
    private static final String A2A_EXECUTOR_KEEP_ALIVE_SECONDS = "a2a.executor.keep-alive-seconds";
    private static final String A2A_EXECUTOR_QUEUE_CAPACITY = "a2a.executor.queue-capacity";
    @Inject
    A2AConfigProvider configProvider;
    int corePoolSize;
    int maxPoolSize;
    long keepAliveSeconds;
    int queueCapacity;
    private @Nullable ExecutorService executor;

    @PostConstruct
    public void init() {
        this.corePoolSize = Integer.parseInt(this.configProvider.getValue(A2A_EXECUTOR_CORE_POOL_SIZE));
        this.maxPoolSize = Integer.parseInt(this.configProvider.getValue(A2A_EXECUTOR_MAX_POOL_SIZE));
        this.keepAliveSeconds = Long.parseLong(this.configProvider.getValue(A2A_EXECUTOR_KEEP_ALIVE_SECONDS));
        this.queueCapacity = Integer.parseInt(this.configProvider.getValue(A2A_EXECUTOR_QUEUE_CAPACITY));
        LOGGER.info("Initializing async executor: corePoolSize={}, maxPoolSize={}, keepAliveSeconds={}, queueCapacity={}", new Object[]{this.corePoolSize, this.maxPoolSize, this.keepAliveSeconds, this.queueCapacity});
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, this.keepAliveSeconds, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.queueCapacity), new A2AThreadFactory());
        tpe.allowCoreThreadTimeOut(true);
        this.executor = tpe;
    }

    @PreDestroy
    public void close() {
        if (this.executor == null) {
            return;
        }
        LOGGER.info("Shutting down async executor");
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                LOGGER.warn("Executor did not terminate in 10 seconds, forcing shutdown");
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Interrupted while waiting for executor shutdown", (Throwable)e);
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    @Produces
    @Internal
    public Executor produce() {
        if (this.executor == null) {
            throw new IllegalStateException("Executor not initialized - @PostConstruct not called");
        }
        return this.executor;
    }

    public void logPoolStats() {
        ExecutorService executorService = this.executor;
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)executorService;
            LOGGER.info("Executor pool stats: active={}/{}, queued={}/{}, completed={}, total={}", new Object[]{tpe.getActiveCount(), tpe.getPoolSize(), tpe.getQueue().size(), this.queueCapacity, tpe.getCompletedTaskCount(), tpe.getTaskCount()});
        }
    }

    private static class A2AThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix = "a2a-agent-executor-";

        private A2AThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "a2a-agent-executor-" + this.threadNumber.getAndIncrement());
            t.setDaemon(false);
            return t;
        }
    }
}

