/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.util;

import io.a2a.spec.Artifact;
import io.a2a.spec.DataPart;
import io.a2a.spec.Part;
import io.a2a.spec.TextPart;
import java.util.List;
import java.util.UUID;
import org.jspecify.annotations.Nullable;

public final class ArtifactUtils {
    private ArtifactUtils() {
    }

    public static Artifact newArtifact(String name, List<Part<?>> parts, @Nullable String description) {
        return new Artifact(UUID.randomUUID().toString(), name, description, parts, null, null);
    }

    public static Artifact newArtifact(String name, List<Part<?>> parts) {
        return ArtifactUtils.newArtifact(name, parts, null);
    }

    public static Artifact newTextArtifact(String name, String text, @Nullable String description) {
        return ArtifactUtils.newArtifact(name, List.of(new TextPart(text)), description);
    }

    public static Artifact newTextArtifact(String name, String text) {
        return ArtifactUtils.newTextArtifact(name, text, null);
    }

    public static Artifact newDataArtifact(String name, Object data, @Nullable String description) {
        return ArtifactUtils.newArtifact(name, List.of(new DataPart(data)), description);
    }

    public static Artifact newDataArtifact(String name, Object data) {
        return ArtifactUtils.newDataArtifact(name, data, null);
    }
}

