/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server;

import io.a2a.server.auth.User;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.Nullable;

public class ServerCallContext {
    private final Map<Object, Object> modelConfig = new ConcurrentHashMap<Object, Object>();
    private final Map<String, Object> state;
    private final User user;
    private final Set<String> requestedExtensions;
    private final Set<String> activatedExtensions;
    private final @Nullable String requestedProtocolVersion;
    private volatile @Nullable Runnable eventConsumerCancelCallback;

    public ServerCallContext(User user, Map<String, Object> state, Set<String> requestedExtensions) {
        this(user, state, requestedExtensions, null);
    }

    public ServerCallContext(User user, Map<String, Object> state, Set<String> requestedExtensions, @Nullable String requestedProtocolVersion) {
        this.user = user;
        this.state = state;
        this.requestedExtensions = new HashSet<String>(requestedExtensions);
        this.activatedExtensions = new HashSet<String>();
        this.requestedProtocolVersion = requestedProtocolVersion;
    }

    public Map<String, Object> getState() {
        return this.state;
    }

    public User getUser() {
        return this.user;
    }

    public Set<String> getRequestedExtensions() {
        return new HashSet<String>(this.requestedExtensions);
    }

    public Set<String> getActivatedExtensions() {
        return new HashSet<String>(this.activatedExtensions);
    }

    public void activateExtension(String extensionUri) {
        this.activatedExtensions.add(extensionUri);
    }

    public void deactivateExtension(String extensionUri) {
        this.activatedExtensions.remove(extensionUri);
    }

    public boolean isExtensionActivated(String extensionUri) {
        return this.activatedExtensions.contains(extensionUri);
    }

    public boolean isExtensionRequested(String extensionUri) {
        return this.requestedExtensions.contains(extensionUri);
    }

    public @Nullable String getRequestedProtocolVersion() {
        return this.requestedProtocolVersion;
    }

    public void setEventConsumerCancelCallback(@Nullable Runnable callback) {
        this.eventConsumerCancelCallback = callback;
    }

    public void invokeEventConsumerCancelCallback() {
        Runnable callback = this.eventConsumerCancelCallback;
        if (callback != null) {
            callback.run();
        }
    }
}

