/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.events;

import io.a2a.server.events.EventQueueClosedException;
import io.a2a.spec.Event;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventQueue
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventQueue.class);
    private static final int queueSize = 1000;
    private final BlockingQueue<Event> queue = new LinkedBlockingDeque<Event>();
    private final Semaphore semaphore = new Semaphore(1000, true);
    private volatile boolean closed = false;

    protected EventQueue() {
        this(null);
    }

    protected EventQueue(EventQueue parent) {
        LOGGER.trace("Creating {}, parent: {}", (Object)this, (Object)parent);
    }

    public static EventQueue create() {
        return new MainQueue();
    }

    public abstract void awaitQueuePollerStart() throws InterruptedException;

    abstract void signalQueuePollerStarted();

    public void enqueueEvent(Event event) {
        if (this.closed) {
            LOGGER.warn("Queue is closed. Event will not be enqueued. {} {}", (Object)this, (Object)event);
            return;
        }
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Unable to acquire the semaphore to enqueue the event", e);
        }
        this.queue.add(event);
        LOGGER.debug("Enqueued event {} {}", (Object)(event instanceof Throwable ? event.toString() : event), (Object)this);
    }

    abstract EventQueue tap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event dequeueEvent(int waitMilliSeconds) throws EventQueueClosedException {
        if (this.closed && this.queue.isEmpty()) {
            LOGGER.debug("Queue is closed, and empty. Sending termination message. {}", (Object)this);
            throw new EventQueueClosedException();
        }
        try {
            if (waitMilliSeconds <= 0) {
                Event event = (Event)this.queue.poll();
                if (event != null) {
                    LOGGER.debug("Dequeued event (no wait) {} {}", (Object)this, (Object)(event instanceof Throwable ? event.toString() : event));
                    this.semaphore.release();
                }
                Event event2 = event;
                return event2;
            }
            Event event = this.queue.poll(waitMilliSeconds, TimeUnit.MILLISECONDS);
            if (event != null) {
                LOGGER.debug("Dequeued event (waiting) {} {}", (Object)this, (Object)(event instanceof Throwable ? event.toString() : event));
                this.semaphore.release();
            }
            Event event3 = event;
            return event3;
        }
        finally {
            this.signalQueuePollerStarted();
        }
    }

    public void taskDone() {
    }

    @Override
    public abstract void close();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doClose() {
        EventQueue eventQueue = this;
        synchronized (eventQueue) {
            if (this.closed) {
                return;
            }
            LOGGER.debug("Closing {}", (Object)this);
            this.closed = true;
        }
    }

    static class MainQueue
    extends EventQueue {
        private final List<ChildQueue> children = new CopyOnWriteArrayList<ChildQueue>();
        private final CountDownLatch pollingStartedLatch = new CountDownLatch(1);
        private final AtomicBoolean pollingStarted = new AtomicBoolean(false);

        MainQueue() {
        }

        @Override
        EventQueue tap() {
            ChildQueue child = new ChildQueue(this);
            this.children.add(child);
            return child;
        }

        @Override
        public void enqueueEvent(Event event) {
            super.enqueueEvent(event);
            this.children.forEach(eq -> eq.internalEnqueueEvent(event));
        }

        @Override
        public void awaitQueuePollerStart() throws InterruptedException {
            LOGGER.debug("Waiting for queue poller to start on {}", (Object)this);
            this.pollingStartedLatch.await(10L, TimeUnit.SECONDS);
            LOGGER.debug("Queue poller started on {}", (Object)this);
        }

        @Override
        void signalQueuePollerStarted() {
            if (this.pollingStarted.get()) {
                return;
            }
            LOGGER.debug("Signalling that queue polling started {}", (Object)this);
            this.pollingStartedLatch.countDown();
            this.pollingStarted.set(true);
        }

        @Override
        public void close() {
            this.doClose();
            this.children.forEach(EventQueue::doClose);
        }
    }

    static class ChildQueue
    extends EventQueue {
        private final MainQueue parent;

        public ChildQueue(MainQueue parent) {
            this.parent = parent;
        }

        @Override
        public void enqueueEvent(Event event) {
            this.parent.enqueueEvent(event);
        }

        private void internalEnqueueEvent(Event event) {
            super.enqueueEvent(event);
        }

        @Override
        EventQueue tap() {
            throw new IllegalStateException("Can only tap the main queue");
        }

        @Override
        public void awaitQueuePollerStart() throws InterruptedException {
            this.parent.awaitQueuePollerStart();
        }

        @Override
        void signalQueuePollerStarted() {
            this.parent.signalQueuePollerStarted();
        }

        @Override
        public void close() {
            this.parent.close();
        }
    }
}

