/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.tasks;

import io.a2a.server.tasks.PushNotificationConfigStore;
import io.a2a.spec.PushNotificationConfig;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@ApplicationScoped
public class InMemoryPushNotificationConfigStore
implements PushNotificationConfigStore {
    private final Map<String, List<PushNotificationConfig>> pushNotificationInfos = Collections.synchronizedMap(new HashMap());

    @Inject
    public InMemoryPushNotificationConfigStore() {
    }

    @Override
    public void setInfo(String taskId, PushNotificationConfig notificationConfig) {
        List notificationConfigList = this.pushNotificationInfos.getOrDefault(taskId, new ArrayList());
        PushNotificationConfig.Builder builder = new PushNotificationConfig.Builder(notificationConfig);
        if (notificationConfig.id() == null) {
            builder.id(taskId);
        }
        notificationConfig = builder.build();
        Iterator notificationConfigIterator = notificationConfigList.iterator();
        while (notificationConfigIterator.hasNext()) {
            PushNotificationConfig config = (PushNotificationConfig)notificationConfigIterator.next();
            if (!config.id().equals(notificationConfig.id())) continue;
            notificationConfigIterator.remove();
            break;
        }
        notificationConfigList.add(notificationConfig);
        this.pushNotificationInfos.put(taskId, notificationConfigList);
    }

    @Override
    public List<PushNotificationConfig> getInfo(String taskId) {
        return this.pushNotificationInfos.get(taskId);
    }

    @Override
    public void deleteInfo(String taskId, String configId) {
        List<PushNotificationConfig> notificationConfigList;
        if (configId == null) {
            configId = taskId;
        }
        if ((notificationConfigList = this.pushNotificationInfos.get(taskId)) == null || notificationConfigList.isEmpty()) {
            return;
        }
        Iterator<PushNotificationConfig> notificationConfigIterator = notificationConfigList.iterator();
        while (notificationConfigIterator.hasNext()) {
            PushNotificationConfig config = notificationConfigIterator.next();
            if (!configId.equals(config.id())) continue;
            notificationConfigIterator.remove();
            break;
        }
        if (notificationConfigList.isEmpty()) {
            this.pushNotificationInfos.remove(taskId);
        }
    }
}

