/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.apps.quarkus;

import com.google.gson.JsonSyntaxException;
import com.google.protobuf.Empty;
import com.google.protobuf.MessageOrBuilder;
import io.a2a.grpc.utils.JSONRPCUtils;
import io.a2a.grpc.utils.ProtoUtils;
import io.a2a.jsonrpc.common.json.IdJsonMappingException;
import io.a2a.jsonrpc.common.json.InvalidParamsJsonMappingException;
import io.a2a.jsonrpc.common.json.JsonMappingException;
import io.a2a.jsonrpc.common.json.JsonProcessingException;
import io.a2a.jsonrpc.common.json.JsonUtil;
import io.a2a.jsonrpc.common.json.MethodNotFoundJsonMappingException;
import io.a2a.jsonrpc.common.wrappers.A2AErrorResponse;
import io.a2a.jsonrpc.common.wrappers.A2ARequest;
import io.a2a.jsonrpc.common.wrappers.A2AResponse;
import io.a2a.jsonrpc.common.wrappers.CancelTaskRequest;
import io.a2a.jsonrpc.common.wrappers.CancelTaskResponse;
import io.a2a.jsonrpc.common.wrappers.CreateTaskPushNotificationConfigRequest;
import io.a2a.jsonrpc.common.wrappers.CreateTaskPushNotificationConfigResponse;
import io.a2a.jsonrpc.common.wrappers.DeleteTaskPushNotificationConfigRequest;
import io.a2a.jsonrpc.common.wrappers.DeleteTaskPushNotificationConfigResponse;
import io.a2a.jsonrpc.common.wrappers.GetExtendedAgentCardRequest;
import io.a2a.jsonrpc.common.wrappers.GetExtendedAgentCardResponse;
import io.a2a.jsonrpc.common.wrappers.GetTaskPushNotificationConfigRequest;
import io.a2a.jsonrpc.common.wrappers.GetTaskPushNotificationConfigResponse;
import io.a2a.jsonrpc.common.wrappers.GetTaskRequest;
import io.a2a.jsonrpc.common.wrappers.GetTaskResponse;
import io.a2a.jsonrpc.common.wrappers.ListTaskPushNotificationConfigRequest;
import io.a2a.jsonrpc.common.wrappers.ListTaskPushNotificationConfigResponse;
import io.a2a.jsonrpc.common.wrappers.ListTasksRequest;
import io.a2a.jsonrpc.common.wrappers.ListTasksResponse;
import io.a2a.jsonrpc.common.wrappers.ListTasksResult;
import io.a2a.jsonrpc.common.wrappers.NonStreamingJSONRPCRequest;
import io.a2a.jsonrpc.common.wrappers.SendMessageRequest;
import io.a2a.jsonrpc.common.wrappers.SendMessageResponse;
import io.a2a.jsonrpc.common.wrappers.SendStreamingMessageRequest;
import io.a2a.jsonrpc.common.wrappers.SendStreamingMessageResponse;
import io.a2a.jsonrpc.common.wrappers.SubscribeToTaskRequest;
import io.a2a.server.ServerCallContext;
import io.a2a.server.apps.quarkus.CallContextFactory;
import io.a2a.server.auth.UnauthenticatedUser;
import io.a2a.server.auth.User;
import io.a2a.server.extensions.A2AExtensions;
import io.a2a.server.util.async.Internal;
import io.a2a.server.util.sse.SseFormatter;
import io.a2a.spec.A2AError;
import io.a2a.spec.AgentCard;
import io.a2a.spec.EventKind;
import io.a2a.spec.InternalError;
import io.a2a.spec.InvalidParamsError;
import io.a2a.spec.InvalidRequestError;
import io.a2a.spec.JSONParseError;
import io.a2a.spec.ListTaskPushNotificationConfigResult;
import io.a2a.spec.MethodNotFoundError;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.Task;
import io.a2a.spec.TaskPushNotificationConfig;
import io.a2a.spec.UnsupportedOperationError;
import io.a2a.transport.jsonrpc.handler.JSONRPCHandler;
import io.quarkus.security.Authenticated;
import io.quarkus.vertx.web.Body;
import io.quarkus.vertx.web.Route;
import io.smallrye.mutiny.Multi;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class A2AServerRoutes {
    @Inject
    JSONRPCHandler jsonRpcHandler;
    private static volatile Runnable streamingMultiSseSupportSubscribedRunnable;
    @Inject
    @Internal
    Executor executor;
    @Inject
    Instance<CallContextFactory> callContextFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Route(path="/", methods={Route.HttpMethod.POST}, consumes={"application/json"}, type=Route.HandlerType.BLOCKING)
    @Authenticated
    public void invokeJSONRPCHandler(@Body String body, RoutingContext rc) {
        boolean streaming = false;
        ServerCallContext context = this.createCallContext(rc);
        A2AResponse<?> nonStreamingResponse = null;
        Multi<? extends A2AResponse<?>> streamingResponse = null;
        A2AErrorResponse error = null;
        try {
            A2ARequest request = JSONRPCUtils.parseRequestBody((String)body, (String)this.extractTenant(rc));
            context.getState().put("method", request.getMethod());
            if (request instanceof NonStreamingJSONRPCRequest) {
                NonStreamingJSONRPCRequest nonStreamingRequest = (NonStreamingJSONRPCRequest)request;
                nonStreamingResponse = this.processNonStreamingRequest(nonStreamingRequest, context);
            } else {
                streaming = true;
                streamingResponse = this.processStreamingRequest(request, context);
            }
        }
        catch (A2AError e) {
            error = new A2AErrorResponse(e);
        }
        catch (InvalidParamsJsonMappingException e) {
            error = new A2AErrorResponse(e.getId(), (A2AError)new InvalidParamsError(null, e.getMessage(), null));
        }
        catch (MethodNotFoundJsonMappingException e) {
            error = new A2AErrorResponse(e.getId(), (A2AError)new MethodNotFoundError(null, e.getMessage(), null));
        }
        catch (IdJsonMappingException e) {
            error = new A2AErrorResponse(e.getId(), (A2AError)new InvalidRequestError(null, e.getMessage(), null));
        }
        catch (JsonMappingException e) {
            error = new A2AErrorResponse((A2AError)new InvalidRequestError(null, e.getMessage(), null));
        }
        catch (JsonSyntaxException e) {
            error = new A2AErrorResponse((A2AError)new JSONParseError(e.getMessage()));
        }
        catch (JsonProcessingException e) {
            error = new A2AErrorResponse((A2AError)new JSONParseError(e.getMessage()));
        }
        catch (Throwable t) {
            error = new A2AErrorResponse((A2AError)new InternalError(t.getMessage()));
        }
        finally {
            if (error != null) {
                rc.response().setStatusCode(200).putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end(A2AServerRoutes.serializeResponse(error));
            } else if (streaming) {
                Multi<? extends A2AResponse<?>> finalStreamingResponse = streamingResponse;
                this.executor.execute(() -> {
                    AtomicLong eventIdCounter = new AtomicLong(0L);
                    Multi sseEvents = finalStreamingResponse.map(response -> SseFormatter.formatResponseAsSSE((A2AResponse)response, (long)eventIdCounter.getAndIncrement()));
                    MultiSseSupport.writeSseStrings((Multi<String>)sseEvents, rc, context);
                });
            } else {
                rc.response().setStatusCode(200).putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end(A2AServerRoutes.serializeResponse(nonStreamingResponse));
            }
        }
    }

    @Route(path="/.well-known/agent-card.json", methods={Route.HttpMethod.GET}, produces={"application/json"})
    public String getAgentCard() throws JsonProcessingException {
        return JsonUtil.toJson((Object)this.jsonRpcHandler.getAgentCard());
    }

    private A2AResponse<?> processNonStreamingRequest(NonStreamingJSONRPCRequest<?> request, ServerCallContext context) {
        if (request instanceof GetTaskRequest) {
            GetTaskRequest req = (GetTaskRequest)request;
            return this.jsonRpcHandler.onGetTask(req, context);
        }
        if (request instanceof CancelTaskRequest) {
            CancelTaskRequest req = (CancelTaskRequest)request;
            return this.jsonRpcHandler.onCancelTask(req, context);
        }
        if (request instanceof ListTasksRequest) {
            ListTasksRequest req = (ListTasksRequest)request;
            return this.jsonRpcHandler.onListTasks(req, context);
        }
        if (request instanceof CreateTaskPushNotificationConfigRequest) {
            CreateTaskPushNotificationConfigRequest req = (CreateTaskPushNotificationConfigRequest)request;
            return this.jsonRpcHandler.setPushNotificationConfig(req, context);
        }
        if (request instanceof GetTaskPushNotificationConfigRequest) {
            GetTaskPushNotificationConfigRequest req = (GetTaskPushNotificationConfigRequest)request;
            return this.jsonRpcHandler.getPushNotificationConfig(req, context);
        }
        if (request instanceof SendMessageRequest) {
            SendMessageRequest req = (SendMessageRequest)request;
            return this.jsonRpcHandler.onMessageSend(req, context);
        }
        if (request instanceof ListTaskPushNotificationConfigRequest) {
            ListTaskPushNotificationConfigRequest req = (ListTaskPushNotificationConfigRequest)request;
            return this.jsonRpcHandler.listPushNotificationConfig(req, context);
        }
        if (request instanceof DeleteTaskPushNotificationConfigRequest) {
            DeleteTaskPushNotificationConfigRequest req = (DeleteTaskPushNotificationConfigRequest)request;
            return this.jsonRpcHandler.deletePushNotificationConfig(req, context);
        }
        if (request instanceof GetExtendedAgentCardRequest) {
            GetExtendedAgentCardRequest req = (GetExtendedAgentCardRequest)request;
            return this.jsonRpcHandler.onGetExtendedCardRequest(req, context);
        }
        return this.generateErrorResponse((A2ARequest<?>)request, (A2AError)new UnsupportedOperationError());
    }

    private Multi<? extends A2AResponse<?>> processStreamingRequest(A2ARequest<?> request, ServerCallContext context) {
        Flow.Publisher publisher;
        if (request instanceof SendStreamingMessageRequest) {
            SendStreamingMessageRequest req = (SendStreamingMessageRequest)request;
            publisher = this.jsonRpcHandler.onMessageSendStream(req, context);
        } else if (request instanceof SubscribeToTaskRequest) {
            SubscribeToTaskRequest req = (SubscribeToTaskRequest)request;
            publisher = this.jsonRpcHandler.onSubscribeToTask(req, context);
        } else {
            return Multi.createFrom().item(this.generateErrorResponse(request, (A2AError)new UnsupportedOperationError()));
        }
        return Multi.createFrom().publisher(publisher);
    }

    private A2AResponse<?> generateErrorResponse(A2ARequest<?> request, A2AError error) {
        return new A2AErrorResponse(request.getId(), error);
    }

    static void setStreamingMultiSseSupportSubscribedRunnable(Runnable runnable) {
        streamingMultiSseSupportSubscribedRunnable = runnable;
    }

    private ServerCallContext createCallContext(final RoutingContext rc) {
        if (this.callContextFactory.isUnsatisfied()) {
            Object user = rc.user() == null ? UnauthenticatedUser.INSTANCE : new User(){

                public boolean isAuthenticated() {
                    return rc.userContext().authenticated();
                }

                public String getUsername() {
                    return rc.user().subject();
                }
            };
            HashMap<String, Object> state = new HashMap<String, Object>();
            HashMap headers = new HashMap();
            Set headerNames = rc.request().headers().names();
            headerNames.forEach(name -> headers.put(name, rc.request().getHeader(name)));
            state.put("headers", headers);
            state.put("tenant", this.extractTenant(rc));
            String requestedVersion = rc.request().getHeader("X-A2A-Version");
            List extensionHeaderValues = rc.request().headers().getAll("X-A2A-Extensions");
            Set requestedExtensions = A2AExtensions.getRequestedExtensions((List)extensionHeaderValues);
            return new ServerCallContext((User)user, state, requestedExtensions, requestedVersion);
        }
        CallContextFactory builder = (CallContextFactory)this.callContextFactory.get();
        return builder.build(rc);
    }

    private String extractTenant(RoutingContext rc) {
        String tenantPath = rc.normalizedPath();
        if (tenantPath == null || tenantPath.isBlank()) {
            return "";
        }
        if (tenantPath.startsWith("/")) {
            tenantPath = tenantPath.substring(1);
        }
        if (tenantPath.endsWith("/")) {
            tenantPath = tenantPath.substring(0, tenantPath.length() - 1);
        }
        return tenantPath;
    }

    private static String serializeResponse(A2AResponse<?> response) {
        if (response instanceof A2AErrorResponse) {
            A2AErrorResponse error = (A2AErrorResponse)response;
            return JSONRPCUtils.toJsonRPCErrorResponse((Object)error.getId(), (A2AError)error.getError());
        }
        if (response.getError() != null) {
            return JSONRPCUtils.toJsonRPCErrorResponse((Object)response.getId(), (A2AError)response.getError());
        }
        MessageOrBuilder protoMessage = A2AServerRoutes.convertToProto(response);
        return JSONRPCUtils.toJsonRPCResultResponse((Object)response.getId(), (MessageOrBuilder)protoMessage);
    }

    private static MessageOrBuilder convertToProto(A2AResponse<?> response) {
        if (response instanceof GetTaskResponse) {
            GetTaskResponse r = (GetTaskResponse)response;
            return ProtoUtils.ToProto.task((Task)((Task)r.getResult()));
        }
        if (response instanceof CancelTaskResponse) {
            CancelTaskResponse r = (CancelTaskResponse)response;
            return ProtoUtils.ToProto.task((Task)((Task)r.getResult()));
        }
        if (response instanceof SendMessageResponse) {
            SendMessageResponse r = (SendMessageResponse)response;
            return ProtoUtils.ToProto.taskOrMessage((EventKind)((EventKind)r.getResult()));
        }
        if (response instanceof ListTasksResponse) {
            ListTasksResponse r = (ListTasksResponse)response;
            return ProtoUtils.ToProto.listTasksResult((ListTasksResult)((ListTasksResult)r.getResult()));
        }
        if (response instanceof CreateTaskPushNotificationConfigResponse) {
            CreateTaskPushNotificationConfigResponse r = (CreateTaskPushNotificationConfigResponse)response;
            return ProtoUtils.ToProto.createTaskPushNotificationConfigResponse((TaskPushNotificationConfig)((TaskPushNotificationConfig)r.getResult()));
        }
        if (response instanceof GetTaskPushNotificationConfigResponse) {
            GetTaskPushNotificationConfigResponse r = (GetTaskPushNotificationConfigResponse)response;
            return ProtoUtils.ToProto.getTaskPushNotificationConfigResponse((TaskPushNotificationConfig)((TaskPushNotificationConfig)r.getResult()));
        }
        if (response instanceof ListTaskPushNotificationConfigResponse) {
            ListTaskPushNotificationConfigResponse r = (ListTaskPushNotificationConfigResponse)response;
            return ProtoUtils.ToProto.listTaskPushNotificationConfigResponse((ListTaskPushNotificationConfigResult)((ListTaskPushNotificationConfigResult)r.getResult()));
        }
        if (response instanceof DeleteTaskPushNotificationConfigResponse) {
            return Empty.getDefaultInstance();
        }
        if (response instanceof GetExtendedAgentCardResponse) {
            GetExtendedAgentCardResponse r = (GetExtendedAgentCardResponse)response;
            return ProtoUtils.ToProto.getExtendedCardResponse((AgentCard)((AgentCard)r.getResult()));
        }
        if (response instanceof SendStreamingMessageResponse) {
            SendStreamingMessageResponse r = (SendStreamingMessageResponse)response;
            return ProtoUtils.ToProto.taskOrMessageStream((StreamingEventKind)((StreamingEventKind)r.getResult()));
        }
        throw new IllegalArgumentException("Unknown response type: " + response.getClass().getName());
    }

    private static class MultiSseSupport {
        private static final Logger logger = LoggerFactory.getLogger(MultiSseSupport.class);

        private MultiSseSupport() {
        }

        public static void writeSseStrings(Multi<String> sseStrings, final RoutingContext rc, final ServerCallContext context) {
            final HttpServerResponse response = rc.response();
            sseStrings.subscribe().withSubscriber((Flow.Subscriber)new Flow.Subscriber<String>(){
                Flow.Subscription upstream;

                @Override
                public void onSubscribe(Flow.Subscription subscription) {
                    this.upstream = subscription;
                    this.upstream.request(1L);
                    response.closeHandler(v -> {
                        logger.info("SSE connection closed by client, calling EventConsumer.cancel() to stop polling loop");
                        context.invokeEventConsumerCancelCallback();
                        subscription.cancel();
                    });
                    Runnable runnable = streamingMultiSseSupportSubscribedRunnable;
                    if (runnable != null) {
                        runnable.run();
                    }
                }

                @Override
                public void onNext(String sseEvent) {
                    if (response.bytesWritten() == 0L) {
                        MultiMap headers = response.headers();
                        if (headers.get(HttpHeaders.CONTENT_TYPE) == null) {
                            headers.set(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/event-stream");
                        }
                        response.setChunked(true);
                    }
                    response.write((Object)Buffer.buffer((String)sseEvent), (Handler)new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> ar) {
                            if (ar.failed()) {
                                upstream.cancel();
                                rc.fail(ar.cause());
                            } else {
                                upstream.request(1L);
                            }
                        }
                    });
                }

                @Override
                public void onError(Throwable throwable) {
                    this.upstream.cancel();
                    rc.fail(throwable);
                }

                @Override
                public void onComplete() {
                    MultiMap headers;
                    if (response.bytesWritten() == 0L && (headers = response.headers()).get(HttpHeaders.CONTENT_TYPE) == null) {
                        headers.set(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/event-stream");
                    }
                    response.end();
                }
            });
        }
    }
}

