/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.extras.opentelemetry.client;

import io.a2a.client.transport.spi.ClientTransport;
import io.a2a.client.transport.spi.interceptors.ClientCallContext;
import io.a2a.jsonrpc.common.wrappers.ListTasksResult;
import io.a2a.spec.A2AClientException;
import io.a2a.spec.AgentCard;
import io.a2a.spec.DeleteTaskPushNotificationConfigParams;
import io.a2a.spec.EventKind;
import io.a2a.spec.GetTaskPushNotificationConfigParams;
import io.a2a.spec.ListTaskPushNotificationConfigParams;
import io.a2a.spec.ListTaskPushNotificationConfigResult;
import io.a2a.spec.ListTasksParams;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.Task;
import io.a2a.spec.TaskIdParams;
import io.a2a.spec.TaskPushNotificationConfig;
import io.a2a.spec.TaskQueryParams;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

public class OpenTelemetryClientTransport
implements ClientTransport {
    private final Tracer tracer;
    private final ClientTransport delegate;

    public OpenTelemetryClientTransport(ClientTransport delegate, Tracer tracer) {
        this.delegate = delegate;
        this.tracer = tracer;
    }

    private boolean extractRequest() {
        return Boolean.getBoolean("io.a2a.server.extract.request");
    }

    private boolean extractResponse() {
        return Boolean.getBoolean("io.a2a.server.extract.response");
    }

    public EventKind sendMessage(MessageSendParams request, @Nullable ClientCallContext context) throws A2AClientException {
        ClientCallContext clientContext = this.createContext(context);
        SpanBuilder spanBuilder = this.tracer.spanBuilder("SendMessage").setSpanKind(SpanKind.CLIENT);
        spanBuilder.setAttribute("gen_ai.agent.a2a.operation.name", "SendMessage");
        if (request.message() != null) {
            if (request.message().taskId() != null) {
                spanBuilder.setAttribute("gen_ai.agent.a2a.task_id", request.message().taskId());
            }
            if (request.message().contextId() != null) {
                spanBuilder.setAttribute("gen_ai.agent.a2a.context_id", request.message().contextId());
            }
            if (request.message().messageId() != null) {
                spanBuilder.setAttribute("gen_ai.agent.a2a.message_id", request.message().messageId());
            }
            if (request.message().role() != null) {
                spanBuilder.setAttribute("gen_ai.agent.a2a.role", request.message().role().name());
            }
            if (request.message().extensions() != null && !request.message().extensions().isEmpty()) {
                spanBuilder.setAttribute("gen_ai.agent.a2a.extensions", String.join((CharSequence)",", request.message().extensions()));
            }
            spanBuilder.setAttribute("gen_ai.agent.a2a.parts.number", (long)request.message().parts().size());
        }
        if (this.extractRequest()) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.request", request.toString());
        }
        Span span = spanBuilder.startSpan();
        try {
            EventKind eventKind;
            block20: {
                Scope scope = span.makeCurrent();
                try {
                    EventKind result = this.delegate.sendMessage(request, clientContext);
                    if (result != null && this.extractResponse()) {
                        span.setAttribute("gen_ai.agent.a2a.response", result.toString());
                    }
                    if (result != null) {
                        span.setStatus(StatusCode.OK);
                    }
                    eventKind = result;
                    if (scope == null) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        span.setStatus(StatusCode.ERROR, ex.getMessage());
                        throw ex;
                    }
                }
                scope.close();
            }
            return eventKind;
        }
        finally {
            span.end();
        }
    }

    public void sendMessageStreaming(MessageSendParams request, Consumer<StreamingEventKind> eventConsumer, Consumer<Throwable> errorConsumer, @Nullable ClientCallContext context) throws A2AClientException {
        ClientCallContext clientContext = this.createContext(context);
        SpanBuilder spanBuilder = this.tracer.spanBuilder("SendStreamingMessage").setSpanKind(SpanKind.CLIENT);
        spanBuilder.setAttribute("gen_ai.agent.a2a.operation.name", "SendStreamingMessage");
        if (request.message() != null) {
            if (request.message().taskId() != null) {
                spanBuilder.setAttribute("gen_ai.agent.a2a.task_id", request.message().taskId());
            }
            if (request.message().contextId() != null) {
                spanBuilder.setAttribute("gen_ai.agent.a2a.context_id", request.message().contextId());
            }
            if (request.message().messageId() != null) {
                spanBuilder.setAttribute("gen_ai.agent.a2a.message_id", request.message().messageId());
            }
            if (request.message().role() != null) {
                spanBuilder.setAttribute("gen_ai.agent.a2a.role", request.message().role().name());
            }
            if (request.message().extensions() != null && !request.message().extensions().isEmpty()) {
                spanBuilder.setAttribute("gen_ai.agent.a2a.extensions", String.join((CharSequence)",", request.message().extensions()));
            }
            spanBuilder.setAttribute("gen_ai.agent.a2a.parts.number", (long)request.message().parts().size());
        }
        if (this.extractRequest()) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.request", request.toString());
        }
        Span span = spanBuilder.startSpan();
        try (Scope scope = span.makeCurrent();){
            this.delegate.sendMessageStreaming(request, (Consumer)new OpenTelemetryEventConsumer("SendStreamingMessage-event", eventConsumer, this.tracer, span.getSpanContext()), (Consumer)new OpenTelemetryErrorConsumer("SendStreamingMessage-error", errorConsumer, this.tracer, span.getSpanContext()), clientContext);
            span.setStatus(StatusCode.OK);
        }
        catch (Exception ex) {
            span.setStatus(StatusCode.ERROR, ex.getMessage());
            throw ex;
        }
        finally {
            span.end();
        }
    }

    public Task getTask(TaskQueryParams request, @Nullable ClientCallContext context) throws A2AClientException {
        ClientCallContext clientContext = this.createContext(context);
        SpanBuilder spanBuilder = this.tracer.spanBuilder("GetTask").setSpanKind(SpanKind.CLIENT);
        spanBuilder.setAttribute("gen_ai.agent.a2a.operation.name", "GetTask");
        if (request.id() != null) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.task_id", request.id());
        }
        if (this.extractRequest()) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.request", request.toString());
        }
        Span span = spanBuilder.startSpan();
        try {
            Task task;
            block15: {
                Scope scope = span.makeCurrent();
                try {
                    Task result = this.delegate.getTask(request, clientContext);
                    if (result != null && this.extractResponse()) {
                        span.setAttribute("gen_ai.agent.a2a.response", result.toString());
                    }
                    if (result != null) {
                        span.setStatus(StatusCode.OK);
                    }
                    task = result;
                    if (scope == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        span.setStatus(StatusCode.ERROR, ex.getMessage());
                        throw ex;
                    }
                }
                scope.close();
            }
            return task;
        }
        finally {
            span.end();
        }
    }

    public Task cancelTask(TaskIdParams request, @Nullable ClientCallContext context) throws A2AClientException {
        ClientCallContext clientContext = this.createContext(context);
        SpanBuilder spanBuilder = this.tracer.spanBuilder("CancelTask").setSpanKind(SpanKind.CLIENT);
        spanBuilder.setAttribute("gen_ai.agent.a2a.operation.name", "CancelTask");
        if (request.id() != null) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.task_id", request.id());
        }
        if (this.extractRequest()) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.request", request.toString());
        }
        Span span = spanBuilder.startSpan();
        try {
            Task task;
            block15: {
                Scope scope = span.makeCurrent();
                try {
                    Task result = this.delegate.cancelTask(request, clientContext);
                    if (result != null && this.extractResponse()) {
                        span.setAttribute("gen_ai.agent.a2a.response", result.toString());
                    }
                    if (result != null) {
                        span.setStatus(StatusCode.OK);
                    }
                    task = result;
                    if (scope == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        span.setStatus(StatusCode.ERROR, ex.getMessage());
                        throw ex;
                    }
                }
                scope.close();
            }
            return task;
        }
        finally {
            span.end();
        }
    }

    public ListTasksResult listTasks(ListTasksParams request, @Nullable ClientCallContext context) throws A2AClientException {
        ClientCallContext clientContext = this.createContext(context);
        SpanBuilder spanBuilder = this.tracer.spanBuilder("ListTasks").setSpanKind(SpanKind.CLIENT);
        spanBuilder.setAttribute("gen_ai.agent.a2a.operation.name", "ListTasks");
        if (this.extractRequest()) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.request", request.toString());
        }
        if (request.contextId() != null) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.context_id", request.contextId());
        }
        Span span = spanBuilder.startSpan();
        try {
            ListTasksResult listTasksResult;
            block15: {
                Scope scope = span.makeCurrent();
                try {
                    ListTasksResult result = this.delegate.listTasks(request, clientContext);
                    if (result != null && this.extractResponse()) {
                        span.setAttribute("gen_ai.agent.a2a.response", result.toString());
                    }
                    if (result != null) {
                        span.setStatus(StatusCode.OK);
                    }
                    listTasksResult = result;
                    if (scope == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        span.setStatus(StatusCode.ERROR, ex.getMessage());
                        throw ex;
                    }
                }
                scope.close();
            }
            return listTasksResult;
        }
        finally {
            span.end();
        }
    }

    public TaskPushNotificationConfig createTaskPushNotificationConfiguration(TaskPushNotificationConfig request, @Nullable ClientCallContext context) throws A2AClientException {
        ClientCallContext clientContext = this.createContext(context);
        SpanBuilder spanBuilder = this.tracer.spanBuilder("CreateTaskPushNotificationConfig").setSpanKind(SpanKind.CLIENT);
        spanBuilder.setAttribute("gen_ai.agent.a2a.operation.name", "CreateTaskPushNotificationConfig");
        if (request.taskId() != null) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.task_id", request.taskId());
        }
        if (request.config() != null && request.config().id() != null) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.config_id", request.config().id());
        }
        if (this.extractRequest()) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.request", request.toString());
        }
        Span span = spanBuilder.startSpan();
        try {
            TaskPushNotificationConfig taskPushNotificationConfig;
            block16: {
                Scope scope = span.makeCurrent();
                try {
                    TaskPushNotificationConfig result = this.delegate.createTaskPushNotificationConfiguration(request, clientContext);
                    if (result != null && this.extractResponse()) {
                        span.setAttribute("gen_ai.agent.a2a.response", result.toString());
                    }
                    if (result != null) {
                        span.setStatus(StatusCode.OK);
                    }
                    taskPushNotificationConfig = result;
                    if (scope == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        span.setStatus(StatusCode.ERROR, ex.getMessage());
                        throw ex;
                    }
                }
                scope.close();
            }
            return taskPushNotificationConfig;
        }
        finally {
            span.end();
        }
    }

    public TaskPushNotificationConfig getTaskPushNotificationConfiguration(GetTaskPushNotificationConfigParams request, @Nullable ClientCallContext context) throws A2AClientException {
        ClientCallContext clientContext = this.createContext(context);
        SpanBuilder spanBuilder = this.tracer.spanBuilder("GetTaskPushNotificationConfig").setSpanKind(SpanKind.CLIENT);
        spanBuilder.setAttribute("gen_ai.agent.a2a.operation.name", "GetTaskPushNotificationConfig");
        if (request.taskId() != null) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.task_id", request.taskId());
        }
        if (request.id() != null) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.config_id", request.id());
        }
        if (this.extractRequest()) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.request", request.toString());
        }
        Span span = spanBuilder.startSpan();
        try {
            TaskPushNotificationConfig taskPushNotificationConfig;
            block16: {
                Scope scope = span.makeCurrent();
                try {
                    TaskPushNotificationConfig result = this.delegate.getTaskPushNotificationConfiguration(request, clientContext);
                    if (result != null && this.extractResponse()) {
                        span.setAttribute("gen_ai.agent.a2a.response", result.toString());
                    }
                    if (result != null) {
                        span.setStatus(StatusCode.OK);
                    }
                    taskPushNotificationConfig = result;
                    if (scope == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        span.setStatus(StatusCode.ERROR, ex.getMessage());
                        throw ex;
                    }
                }
                scope.close();
            }
            return taskPushNotificationConfig;
        }
        finally {
            span.end();
        }
    }

    public ListTaskPushNotificationConfigResult listTaskPushNotificationConfigurations(ListTaskPushNotificationConfigParams request, @Nullable ClientCallContext context) throws A2AClientException {
        ClientCallContext clientContext = this.createContext(context);
        SpanBuilder spanBuilder = this.tracer.spanBuilder("ListTaskPushNotificationConfig").setSpanKind(SpanKind.CLIENT);
        spanBuilder.setAttribute("gen_ai.agent.a2a.operation.name", "ListTaskPushNotificationConfig");
        if (this.extractRequest()) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.request", request.toString());
        }
        if (request.id() != null) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.task_id", request.id());
        }
        Span span = spanBuilder.startSpan();
        try {
            ListTaskPushNotificationConfigResult listTaskPushNotificationConfigResult;
            block15: {
                Scope scope = span.makeCurrent();
                try {
                    ListTaskPushNotificationConfigResult result = this.delegate.listTaskPushNotificationConfigurations(request, clientContext);
                    if (result != null && this.extractResponse()) {
                        String responseValue = result.configs().stream().map(TaskPushNotificationConfig::toString).collect(Collectors.joining(","));
                        span.setAttribute("gen_ai.agent.a2a.response", responseValue);
                    }
                    if (result != null) {
                        span.setStatus(StatusCode.OK);
                    }
                    listTaskPushNotificationConfigResult = result;
                    if (scope == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        span.setStatus(StatusCode.ERROR, ex.getMessage());
                        throw ex;
                    }
                }
                scope.close();
            }
            return listTaskPushNotificationConfigResult;
        }
        finally {
            span.end();
        }
    }

    public void deleteTaskPushNotificationConfigurations(DeleteTaskPushNotificationConfigParams request, @Nullable ClientCallContext context) throws A2AClientException {
        ClientCallContext clientContext = this.createContext(context);
        SpanBuilder spanBuilder = this.tracer.spanBuilder("DeleteTaskPushNotificationConfig").setSpanKind(SpanKind.CLIENT);
        spanBuilder.setAttribute("gen_ai.agent.a2a.operation.name", "DeleteTaskPushNotificationConfig");
        if (this.extractRequest()) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.request", request.toString());
        }
        if (request.taskId() != null) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.task_id", request.taskId());
        }
        if (request.id() != null) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.config_id", request.id());
        }
        Span span = spanBuilder.startSpan();
        try (Scope scope = span.makeCurrent();){
            this.delegate.deleteTaskPushNotificationConfigurations(request, clientContext);
            span.setStatus(StatusCode.OK);
        }
        catch (Exception ex) {
            span.setStatus(StatusCode.ERROR, ex.getMessage());
            throw ex;
        }
        finally {
            span.end();
        }
    }

    public void subscribeToTask(TaskIdParams request, Consumer<StreamingEventKind> eventConsumer, Consumer<Throwable> errorConsumer, @Nullable ClientCallContext context) throws A2AClientException {
        ClientCallContext clientContext = this.createContext(context);
        SpanBuilder spanBuilder = this.tracer.spanBuilder("SubscribeToTask").setSpanKind(SpanKind.CLIENT);
        spanBuilder.setAttribute("gen_ai.agent.a2a.operation.name", "SubscribeToTask");
        if (request.id() != null) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.task_id", request.id());
        }
        if (this.extractRequest()) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.request", request.toString());
        }
        Span span = spanBuilder.startSpan();
        try (Scope scope = span.makeCurrent();){
            this.delegate.subscribeToTask(request, (Consumer)new OpenTelemetryEventConsumer("SubscribeToTask-event", eventConsumer, this.tracer, span.getSpanContext()), (Consumer)new OpenTelemetryErrorConsumer("SubscribeToTask-error", errorConsumer, this.tracer, span.getSpanContext()), clientContext);
            span.setStatus(StatusCode.OK);
        }
        catch (Exception ex) {
            span.setStatus(StatusCode.ERROR, ex.getMessage());
            throw ex;
        }
        finally {
            span.end();
        }
    }

    public AgentCard getExtendedAgentCard(@Nullable ClientCallContext context) throws A2AClientException {
        ClientCallContext clientContext = this.createContext(context);
        SpanBuilder spanBuilder = this.tracer.spanBuilder("GetExtendedAgentCard").setSpanKind(SpanKind.CLIENT);
        spanBuilder.setAttribute("gen_ai.agent.a2a.operation.name", "GetExtendedAgentCard");
        Span span = spanBuilder.startSpan();
        try {
            AgentCard agentCard;
            block13: {
                Scope scope = span.makeCurrent();
                try {
                    AgentCard result = this.delegate.getExtendedAgentCard(clientContext);
                    if (result != null && this.extractResponse()) {
                        span.setAttribute("gen_ai.agent.a2a.response", result.toString());
                    }
                    if (result != null) {
                        span.setStatus(StatusCode.OK);
                    }
                    agentCard = result;
                    if (scope == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        span.setStatus(StatusCode.ERROR, ex.getMessage());
                        throw ex;
                    }
                }
                scope.close();
            }
            return agentCard;
        }
        finally {
            span.end();
        }
    }

    private ClientCallContext createContext(@Nullable ClientCallContext context) {
        if (context == null) {
            return new ClientCallContext(Map.of(), new HashMap());
        }
        return new ClientCallContext(context.getState(), new HashMap(context.getHeaders()));
    }

    public void close() {
        this.delegate.close();
    }

    private static class OpenTelemetryEventConsumer
    implements Consumer<StreamingEventKind> {
        private final Consumer<StreamingEventKind> delegate;
        private final Tracer tracer;
        private final SpanContext context;
        private final String name;

        public OpenTelemetryEventConsumer(String name, Consumer<StreamingEventKind> delegate, Tracer tracer, SpanContext context) {
            this.delegate = delegate;
            this.tracer = tracer;
            this.context = context;
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(StreamingEventKind t) {
            SpanBuilder spanBuilder = this.tracer.spanBuilder(this.name).setSpanKind(SpanKind.CLIENT);
            spanBuilder.setAttribute("gen_ai.agent.a2a.streaming-event", t.toString());
            spanBuilder.addLink(this.context);
            Span span = spanBuilder.startSpan();
            try {
                this.delegate.accept(t);
                span.setStatus(StatusCode.OK);
            }
            finally {
                span.end();
            }
        }
    }

    private static class OpenTelemetryErrorConsumer
    implements Consumer<Throwable> {
        private final Consumer<Throwable> delegate;
        private final Tracer tracer;
        private final SpanContext context;
        private final String name;

        public OpenTelemetryErrorConsumer(String name, Consumer<Throwable> delegate, Tracer tracer, SpanContext context) {
            this.delegate = delegate;
            this.tracer = tracer;
            this.context = context;
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(Throwable t) {
            if (t == null) {
                return;
            }
            SpanBuilder spanBuilder = this.tracer.spanBuilder(this.name).setSpanKind(SpanKind.CLIENT);
            spanBuilder.addLink(this.context);
            Span span = spanBuilder.startSpan();
            try {
                span.setStatus(StatusCode.ERROR, t.getMessage());
                this.delegate.accept(t);
            }
            finally {
                span.end();
            }
        }
    }
}

