/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.extras.opentelemetry.client;

import io.a2a.client.transport.spi.ClientTransport;
import io.a2a.client.transport.spi.ClientTransportConfig;
import io.a2a.client.transport.spi.ClientTransportWrapper;
import io.a2a.extras.opentelemetry.client.OpenTelemetryClientTransport;
import io.opentelemetry.api.trace.Tracer;

public class OpenTelemetryClientTransportWrapper
implements ClientTransportWrapper {
    public static final String OTEL_TRACER_KEY = "io.a2a.extras.opentelemetry.Tracer";

    public ClientTransport wrap(ClientTransport transport, ClientTransportConfig<?> config) {
        Object tracerObj = config.getParameters().get(OTEL_TRACER_KEY);
        if (tracerObj != null && tracerObj instanceof Tracer) {
            Tracer tracer = (Tracer)tracerObj;
            return new OpenTelemetryClientTransport(transport, tracer);
        }
        return transport;
    }

    public int priority() {
        return 600;
    }
}

