/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.client;

import io.a2a.spec.A2AClientError;
import io.a2a.spec.A2AClientInvalidArgsError;
import io.a2a.spec.A2AClientInvalidStateError;
import io.a2a.spec.Message;
import io.a2a.spec.Task;
import io.a2a.spec.TaskArtifactUpdateEvent;
import io.a2a.spec.TaskState;
import io.a2a.spec.TaskStatus;
import io.a2a.spec.TaskStatusUpdateEvent;
import io.a2a.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import org.jspecify.annotations.Nullable;

public class ClientTaskManager {
    private @Nullable Task currentTask = null;
    private @Nullable String taskId = null;
    private @Nullable String contextId = null;

    public Task getCurrentTask() throws A2AClientInvalidStateError {
        if (this.currentTask == null) {
            throw new A2AClientInvalidStateError("No current task");
        }
        return this.currentTask;
    }

    public Task saveTaskEvent(Task task) throws A2AClientInvalidArgsError {
        if (this.currentTask != null) {
            throw new A2AClientInvalidArgsError("Task is already set, create new manager for new tasks.");
        }
        this.saveTask(task);
        return task;
    }

    public Task saveTaskEvent(TaskStatusUpdateEvent taskStatusUpdateEvent) throws A2AClientError {
        Task task;
        if (this.taskId == null) {
            this.taskId = taskStatusUpdateEvent.taskId();
        }
        if (this.contextId == null) {
            this.contextId = taskStatusUpdateEvent.contextId();
        }
        if ((task = this.currentTask) == null) {
            task = Task.builder().status(new TaskStatus(TaskState.UNRECOGNIZED)).id(this.taskId).contextId(this.contextId == null ? "" : this.contextId).build();
        }
        Task.Builder taskBuilder = Task.builder((Task)task);
        if (taskStatusUpdateEvent.status().message() != null) {
            if (task.history() == null) {
                taskBuilder.history(new Message[]{taskStatusUpdateEvent.status().message()});
            } else {
                ArrayList<Message> history = new ArrayList<Message>(task.history());
                history.add(taskStatusUpdateEvent.status().message());
                taskBuilder.history(history);
            }
        }
        if (taskStatusUpdateEvent.metadata() != null) {
            HashMap newMetadata = task.metadata() != null ? new HashMap(task.metadata()) : new HashMap();
            newMetadata.putAll(taskStatusUpdateEvent.metadata());
            taskBuilder.metadata(newMetadata);
        }
        taskBuilder.status(taskStatusUpdateEvent.status());
        this.currentTask = taskBuilder.build();
        return this.currentTask;
    }

    public Task saveTaskEvent(TaskArtifactUpdateEvent taskArtifactUpdateEvent) {
        Task task;
        if (this.taskId == null) {
            this.taskId = taskArtifactUpdateEvent.taskId();
        }
        if (this.contextId == null) {
            this.contextId = taskArtifactUpdateEvent.contextId();
        }
        if ((task = this.currentTask) == null) {
            task = Task.builder().status(new TaskStatus(TaskState.UNRECOGNIZED)).id(this.taskId).contextId(this.contextId == null ? "" : this.contextId).build();
        }
        this.currentTask = Utils.appendArtifactToTask((Task)task, (TaskArtifactUpdateEvent)taskArtifactUpdateEvent, (String)this.taskId);
        return this.currentTask;
    }

    public Task updateWithMessage(Message message, Task task) {
        Task.Builder taskBuilder = Task.builder((Task)task);
        ArrayList<Message> history = new ArrayList<Message>(task.history());
        if (task.status().message() != null) {
            history.add(task.status().message());
            taskBuilder.status(new TaskStatus(task.status().state(), null, task.status().timestamp()));
        }
        history.add(message);
        taskBuilder.history(history);
        this.currentTask = taskBuilder.build();
        return this.currentTask;
    }

    private void saveTask(Task task) {
        this.currentTask = task;
        if (this.taskId == null) {
            this.taskId = this.currentTask.id();
            this.contextId = this.currentTask.contextId();
        }
    }
}

