/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.client;

import io.a2a.client.ClientEvent;
import io.a2a.client.transport.spi.interceptors.ClientCallContext;
import io.a2a.jsonrpc.common.wrappers.ListTasksResult;
import io.a2a.spec.A2AClientException;
import io.a2a.spec.AgentCard;
import io.a2a.spec.DeleteTaskPushNotificationConfigParams;
import io.a2a.spec.GetTaskPushNotificationConfigParams;
import io.a2a.spec.ListTaskPushNotificationConfigParams;
import io.a2a.spec.ListTaskPushNotificationConfigResult;
import io.a2a.spec.ListTasksParams;
import io.a2a.spec.Message;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.PushNotificationConfig;
import io.a2a.spec.Task;
import io.a2a.spec.TaskIdParams;
import io.a2a.spec.TaskPushNotificationConfig;
import io.a2a.spec.TaskQueryParams;
import io.a2a.util.Assert;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class AbstractClient
implements AutoCloseable {
    protected final @NonNull List<BiConsumer<ClientEvent, AgentCard>> consumers;
    protected final @Nullable Consumer<Throwable> streamingErrorHandler;

    public AbstractClient(@NonNull List<BiConsumer<ClientEvent, AgentCard>> consumers) {
        this(consumers, null);
    }

    public AbstractClient(@NonNull List<BiConsumer<ClientEvent, AgentCard>> consumers, @Nullable Consumer<Throwable> streamingErrorHandler) {
        Assert.checkNotNullParam((String)"consumers", consumers);
        this.consumers = consumers;
        this.streamingErrorHandler = streamingErrorHandler;
    }

    public void sendMessage(@NonNull Message request) throws A2AClientException {
        this.sendMessage(request, null);
    }

    public void sendMessage(@NonNull Message request, @Nullable ClientCallContext context) throws A2AClientException {
        this.sendMessage(request, this.consumers, this.streamingErrorHandler, context);
    }

    public void sendMessage(@NonNull Message request, @NonNull List<BiConsumer<ClientEvent, AgentCard>> consumers, @Nullable Consumer<Throwable> streamingErrorHandler) throws A2AClientException {
        this.sendMessage(request, consumers, streamingErrorHandler, null);
    }

    public abstract void sendMessage(@NonNull Message var1, @NonNull List<BiConsumer<ClientEvent, AgentCard>> var2, @Nullable Consumer<Throwable> var3, @Nullable ClientCallContext var4) throws A2AClientException;

    public void sendMessage(@NonNull Message request, @Nullable PushNotificationConfig pushNotificationConfiguration, @Nullable Map<String, Object> metadata) throws A2AClientException {
        this.sendMessage(request, pushNotificationConfiguration, metadata, null);
    }

    public abstract void sendMessage(@NonNull Message var1, @Nullable PushNotificationConfig var2, @Nullable Map<String, Object> var3, @Nullable ClientCallContext var4) throws A2AClientException;

    public abstract void sendMessage(@NonNull MessageSendParams var1, @NonNull List<BiConsumer<ClientEvent, AgentCard>> var2, @Nullable Consumer<Throwable> var3, @Nullable ClientCallContext var4) throws A2AClientException;

    public Task getTask(TaskQueryParams request) throws A2AClientException {
        return this.getTask(request, null);
    }

    public abstract Task getTask(TaskQueryParams var1, @Nullable ClientCallContext var2) throws A2AClientException;

    public ListTasksResult listTasks(ListTasksParams request) throws A2AClientException {
        return this.listTasks(request, null);
    }

    public abstract ListTasksResult listTasks(ListTasksParams var1, @Nullable ClientCallContext var2) throws A2AClientException;

    public Task cancelTask(TaskIdParams request) throws A2AClientException {
        return this.cancelTask(request, null);
    }

    public abstract Task cancelTask(TaskIdParams var1, @Nullable ClientCallContext var2) throws A2AClientException;

    public TaskPushNotificationConfig createTaskPushNotificationConfiguration(TaskPushNotificationConfig request) throws A2AClientException {
        return this.createTaskPushNotificationConfiguration(request, null);
    }

    public abstract TaskPushNotificationConfig createTaskPushNotificationConfiguration(TaskPushNotificationConfig var1, @Nullable ClientCallContext var2) throws A2AClientException;

    public TaskPushNotificationConfig getTaskPushNotificationConfiguration(GetTaskPushNotificationConfigParams request) throws A2AClientException {
        return this.getTaskPushNotificationConfiguration(request, null);
    }

    public abstract TaskPushNotificationConfig getTaskPushNotificationConfiguration(GetTaskPushNotificationConfigParams var1, @Nullable ClientCallContext var2) throws A2AClientException;

    public ListTaskPushNotificationConfigResult listTaskPushNotificationConfigurations(ListTaskPushNotificationConfigParams request) throws A2AClientException {
        return this.listTaskPushNotificationConfigurations(request, null);
    }

    public abstract ListTaskPushNotificationConfigResult listTaskPushNotificationConfigurations(ListTaskPushNotificationConfigParams var1, @Nullable ClientCallContext var2) throws A2AClientException;

    public void deleteTaskPushNotificationConfigurations(DeleteTaskPushNotificationConfigParams request) throws A2AClientException {
        this.deleteTaskPushNotificationConfigurations(request, null);
    }

    public abstract void deleteTaskPushNotificationConfigurations(DeleteTaskPushNotificationConfigParams var1, @Nullable ClientCallContext var2) throws A2AClientException;

    public void subscribeToTask(@NonNull TaskIdParams request) throws A2AClientException {
        this.subscribeToTask(request, this.consumers, this.streamingErrorHandler, null);
    }

    public void subscribeToTask(@NonNull TaskIdParams request, @Nullable ClientCallContext context) throws A2AClientException {
        this.subscribeToTask(request, this.consumers, this.streamingErrorHandler, context);
    }

    public void subscribeToTask(@NonNull TaskIdParams request, @NonNull List<BiConsumer<ClientEvent, AgentCard>> consumers, @Nullable Consumer<Throwable> streamingErrorHandler) throws A2AClientException {
        this.subscribeToTask(request, consumers, streamingErrorHandler, null);
    }

    public abstract void subscribeToTask(@NonNull TaskIdParams var1, @NonNull List<BiConsumer<ClientEvent, AgentCard>> var2, @Nullable Consumer<Throwable> var3, @Nullable ClientCallContext var4) throws A2AClientException;

    public AgentCard getExtendedAgentCard() throws A2AClientException {
        return this.getExtendedAgentCard(null);
    }

    public abstract AgentCard getExtendedAgentCard(@Nullable ClientCallContext var1) throws A2AClientException;

    @Override
    public abstract void close();

    public @Nullable Consumer<Throwable> getStreamingErrorHandler() {
        return this.streamingErrorHandler;
    }
}

