/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.client.transport.jsonrpc;

import com.google.protobuf.MessageOrBuilder;
import io.a2a.client.http.A2ACardResolver;
import io.a2a.client.http.A2AHttpClient;
import io.a2a.client.http.A2AHttpClientFactory;
import io.a2a.client.http.A2AHttpResponse;
import io.a2a.client.transport.jsonrpc.sse.SSEEventListener;
import io.a2a.client.transport.spi.ClientTransport;
import io.a2a.client.transport.spi.interceptors.ClientCallContext;
import io.a2a.client.transport.spi.interceptors.ClientCallInterceptor;
import io.a2a.client.transport.spi.interceptors.PayloadAndHeaders;
import io.a2a.grpc.utils.JSONRPCUtils;
import io.a2a.grpc.utils.ProtoUtils;
import io.a2a.jsonrpc.common.json.JsonProcessingException;
import io.a2a.jsonrpc.common.wrappers.A2AResponse;
import io.a2a.jsonrpc.common.wrappers.CancelTaskResponse;
import io.a2a.jsonrpc.common.wrappers.DeleteTaskPushNotificationConfigResponse;
import io.a2a.jsonrpc.common.wrappers.GetAuthenticatedExtendedCardRequest;
import io.a2a.jsonrpc.common.wrappers.GetAuthenticatedExtendedCardResponse;
import io.a2a.jsonrpc.common.wrappers.GetTaskPushNotificationConfigResponse;
import io.a2a.jsonrpc.common.wrappers.GetTaskResponse;
import io.a2a.jsonrpc.common.wrappers.ListTaskPushNotificationConfigResponse;
import io.a2a.jsonrpc.common.wrappers.ListTasksResponse;
import io.a2a.jsonrpc.common.wrappers.ListTasksResult;
import io.a2a.jsonrpc.common.wrappers.SendMessageResponse;
import io.a2a.jsonrpc.common.wrappers.SetTaskPushNotificationConfigResponse;
import io.a2a.spec.A2AClientError;
import io.a2a.spec.A2AClientException;
import io.a2a.spec.A2AError;
import io.a2a.spec.AgentCard;
import io.a2a.spec.AgentInterface;
import io.a2a.spec.DeleteTaskPushNotificationConfigParams;
import io.a2a.spec.EventKind;
import io.a2a.spec.GetTaskPushNotificationConfigParams;
import io.a2a.spec.ListTaskPushNotificationConfigParams;
import io.a2a.spec.ListTaskPushNotificationConfigResult;
import io.a2a.spec.ListTasksParams;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.Task;
import io.a2a.spec.TaskIdParams;
import io.a2a.spec.TaskPushNotificationConfig;
import io.a2a.spec.TaskQueryParams;
import io.a2a.util.Assert;
import io.a2a.util.Utils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;

public class JSONRPCTransport
implements ClientTransport {
    private final A2AHttpClient httpClient;
    private final AgentInterface agentInterface;
    private final @Nullable List<ClientCallInterceptor> interceptors;
    private @Nullable AgentCard agentCard;
    private boolean needsExtendedCard = false;

    public JSONRPCTransport(String agentUrl) {
        this(null, null, new AgentInterface("JSONRPC", agentUrl), null);
    }

    public JSONRPCTransport(AgentCard agentCard) {
        this(null, agentCard, Utils.getFavoriteInterface((AgentCard)agentCard), null);
    }

    public JSONRPCTransport(@Nullable A2AHttpClient httpClient, @Nullable AgentCard agentCard, AgentInterface agentInterface, @Nullable List<ClientCallInterceptor> interceptors) {
        this.httpClient = httpClient == null ? A2AHttpClientFactory.create() : httpClient;
        this.agentCard = agentCard;
        this.agentInterface = agentInterface;
        this.interceptors = interceptors;
        this.needsExtendedCard = agentCard == null || agentCard.supportsExtendedAgentCard();
    }

    public EventKind sendMessage(MessageSendParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("SendMessage", ProtoUtils.ToProto.sendMessageRequest((MessageSendParams)request), this.agentCard, context);
        try {
            String httpResponseBody = this.sendPostRequest(Utils.buildBaseUrl((AgentInterface)this.agentInterface, (String)request.tenant()), payloadAndHeaders, "SendMessage");
            SendMessageResponse response = (SendMessageResponse)this.unmarshalResponse(httpResponseBody, "SendMessage");
            return (EventKind)response.getResult();
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (JsonProcessingException | IOException | InterruptedException e) {
            throw new A2AClientException("Failed to send message: " + String.valueOf(e), e);
        }
    }

    public void sendMessageStreaming(MessageSendParams request, Consumer<StreamingEventKind> eventConsumer, @Nullable Consumer<Throwable> errorConsumer, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        Assert.checkNotNullParam((String)"eventConsumer", eventConsumer);
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("SendStreamingMessage", ProtoUtils.ToProto.sendMessageRequest((MessageSendParams)request), this.agentCard, context);
        AtomicReference<CompletableFuture> ref = new AtomicReference<CompletableFuture>();
        SSEEventListener sseEventListener = new SSEEventListener(eventConsumer, errorConsumer);
        try {
            A2AHttpClient.PostBuilder builder = this.createPostBuilder(Utils.buildBaseUrl((AgentInterface)this.agentInterface, (String)request.tenant()), payloadAndHeaders, "SendStreamingMessage");
            ref.set(builder.postAsyncSSE(msg -> sseEventListener.onMessage((String)msg, (Future)ref.get()), throwable -> sseEventListener.onError((Throwable)throwable, (Future)ref.get()), () -> sseEventListener.onComplete()));
        }
        catch (IOException e) {
            throw new A2AClientException("Failed to send streaming message request: " + String.valueOf(e), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new A2AClientException("Send streaming message request timed out: " + String.valueOf(e), (Throwable)e);
        }
        catch (JsonProcessingException e) {
            throw new A2AClientException("Failed to process JSON for streaming message request: " + String.valueOf((Object)e), (Throwable)e);
        }
    }

    public Task getTask(TaskQueryParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("GetTask", ProtoUtils.ToProto.getTaskRequest((TaskQueryParams)request), this.agentCard, context);
        try {
            String httpResponseBody = this.sendPostRequest(Utils.buildBaseUrl((AgentInterface)this.agentInterface, (String)request.tenant()), payloadAndHeaders, "GetTask");
            GetTaskResponse response = (GetTaskResponse)this.unmarshalResponse(httpResponseBody, "GetTask");
            return (Task)response.getResult();
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (JsonProcessingException | IOException | InterruptedException e) {
            throw new A2AClientException("Failed to get task: " + String.valueOf(e), e);
        }
    }

    public Task cancelTask(TaskIdParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("CancelTask", ProtoUtils.ToProto.cancelTaskRequest((TaskIdParams)request), this.agentCard, context);
        try {
            String httpResponseBody = this.sendPostRequest(Utils.buildBaseUrl((AgentInterface)this.agentInterface, (String)request.tenant()), payloadAndHeaders, "CancelTask");
            CancelTaskResponse response = (CancelTaskResponse)this.unmarshalResponse(httpResponseBody, "CancelTask");
            return (Task)response.getResult();
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (JsonProcessingException | IOException | InterruptedException e) {
            throw new A2AClientException("Failed to cancel task: " + String.valueOf(e), e);
        }
    }

    public ListTasksResult listTasks(ListTasksParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("ListTasks", ProtoUtils.ToProto.listTasksParams((ListTasksParams)request), this.agentCard, context);
        try {
            String httpResponseBody = this.sendPostRequest(Utils.buildBaseUrl((AgentInterface)this.agentInterface, (String)request.tenant()), payloadAndHeaders, "ListTasks");
            ListTasksResponse response = (ListTasksResponse)this.unmarshalResponse(httpResponseBody, "ListTasks");
            return (ListTasksResult)response.getResult();
        }
        catch (JsonProcessingException | IOException | InterruptedException e) {
            throw new A2AClientException("Failed to list tasks: " + String.valueOf(e), e);
        }
    }

    public TaskPushNotificationConfig setTaskPushNotificationConfiguration(TaskPushNotificationConfig request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("SetTaskPushNotificationConfig", ProtoUtils.ToProto.setTaskPushNotificationConfigRequest((TaskPushNotificationConfig)request), this.agentCard, context);
        try {
            String httpResponseBody = this.sendPostRequest(Utils.buildBaseUrl((AgentInterface)this.agentInterface, (String)request.tenant()), payloadAndHeaders, "SetTaskPushNotificationConfig");
            SetTaskPushNotificationConfigResponse response = (SetTaskPushNotificationConfigResponse)this.unmarshalResponse(httpResponseBody, "SetTaskPushNotificationConfig");
            return (TaskPushNotificationConfig)response.getResult();
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (JsonProcessingException | IOException | InterruptedException e) {
            throw new A2AClientException("Failed to set task push notification config: " + String.valueOf(e), e);
        }
    }

    public TaskPushNotificationConfig getTaskPushNotificationConfiguration(GetTaskPushNotificationConfigParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("GetTaskPushNotificationConfig", ProtoUtils.ToProto.getTaskPushNotificationConfigRequest((GetTaskPushNotificationConfigParams)request), this.agentCard, context);
        try {
            String httpResponseBody = this.sendPostRequest(Utils.buildBaseUrl((AgentInterface)this.agentInterface, (String)request.tenant()), payloadAndHeaders, "GetTaskPushNotificationConfig");
            GetTaskPushNotificationConfigResponse response = (GetTaskPushNotificationConfigResponse)this.unmarshalResponse(httpResponseBody, "GetTaskPushNotificationConfig");
            return (TaskPushNotificationConfig)response.getResult();
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (JsonProcessingException | IOException | InterruptedException e) {
            throw new A2AClientException("Failed to get task push notification config: " + String.valueOf(e), e);
        }
    }

    public ListTaskPushNotificationConfigResult listTaskPushNotificationConfigurations(ListTaskPushNotificationConfigParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("ListTaskPushNotificationConfig", ProtoUtils.ToProto.listTaskPushNotificationConfigRequest((ListTaskPushNotificationConfigParams)request), this.agentCard, context);
        try {
            String httpResponseBody = this.sendPostRequest(Utils.buildBaseUrl((AgentInterface)this.agentInterface, (String)request.tenant()), payloadAndHeaders, "ListTaskPushNotificationConfig");
            ListTaskPushNotificationConfigResponse response = (ListTaskPushNotificationConfigResponse)this.unmarshalResponse(httpResponseBody, "ListTaskPushNotificationConfig");
            return (ListTaskPushNotificationConfigResult)response.getResult();
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (JsonProcessingException | IOException | InterruptedException e) {
            throw new A2AClientException("Failed to list task push notification configs: " + String.valueOf(e), e);
        }
    }

    public void deleteTaskPushNotificationConfigurations(DeleteTaskPushNotificationConfigParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("DeleteTaskPushNotificationConfig", ProtoUtils.ToProto.deleteTaskPushNotificationConfigRequest((DeleteTaskPushNotificationConfigParams)request), this.agentCard, context);
        try {
            String httpResponseBody = this.sendPostRequest(Utils.buildBaseUrl((AgentInterface)this.agentInterface, (String)request.tenant()), payloadAndHeaders, "DeleteTaskPushNotificationConfig");
            DeleteTaskPushNotificationConfigResponse deleteTaskPushNotificationConfigResponse = (DeleteTaskPushNotificationConfigResponse)this.unmarshalResponse(httpResponseBody, "DeleteTaskPushNotificationConfig");
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (JsonProcessingException | IOException | InterruptedException e) {
            throw new A2AClientException("Failed to delete task push notification configs: " + String.valueOf(e), e);
        }
    }

    public void resubscribe(TaskIdParams request, Consumer<StreamingEventKind> eventConsumer, Consumer<Throwable> errorConsumer, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        Assert.checkNotNullParam((String)"eventConsumer", eventConsumer);
        Assert.checkNotNullParam((String)"errorConsumer", errorConsumer);
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("SubscribeToTask", ProtoUtils.ToProto.subscribeToTaskRequest((TaskIdParams)request), this.agentCard, context);
        AtomicReference<CompletableFuture> ref = new AtomicReference<CompletableFuture>();
        SSEEventListener sseEventListener = new SSEEventListener(eventConsumer, errorConsumer);
        try {
            A2AHttpClient.PostBuilder builder = this.createPostBuilder(Utils.buildBaseUrl((AgentInterface)this.agentInterface, (String)request.tenant()), payloadAndHeaders, "SubscribeToTask");
            ref.set(builder.postAsyncSSE(msg -> sseEventListener.onMessage((String)msg, (Future)ref.get()), throwable -> sseEventListener.onError((Throwable)throwable, (Future)ref.get()), () -> sseEventListener.onComplete()));
        }
        catch (IOException e) {
            throw new A2AClientException("Failed to send task resubscription request: " + String.valueOf(e), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new A2AClientException("Task resubscription request timed out: " + String.valueOf(e), (Throwable)e);
        }
        catch (JsonProcessingException e) {
            throw new A2AClientException("Failed to process JSON for task resubscription request: " + String.valueOf((Object)e), (Throwable)e);
        }
    }

    public AgentCard getAgentCard(@Nullable ClientCallContext context) throws A2AClientException {
        try {
            if (this.agentCard == null) {
                A2ACardResolver resolver = new A2ACardResolver(this.httpClient, this.agentInterface.url(), this.agentInterface.tenant(), null, this.getHttpHeaders(context));
                this.agentCard = resolver.getAgentCard();
                this.needsExtendedCard = this.agentCard.supportsExtendedAgentCard();
            }
            if (!this.needsExtendedCard) {
                return this.agentCard;
            }
            GetAuthenticatedExtendedCardRequest getExtendedAgentCardRequest = GetAuthenticatedExtendedCardRequest.builder().jsonrpc("2.0").build();
            PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("GetExtendedAgentCard", ProtoUtils.ToProto.extendedAgentCard(), this.agentCard, context);
            try {
                String httpResponseBody = this.sendPostRequest(Utils.buildBaseUrl((AgentInterface)this.agentInterface, (String)""), payloadAndHeaders, "GetExtendedAgentCard");
                GetAuthenticatedExtendedCardResponse response = (GetAuthenticatedExtendedCardResponse)this.unmarshalResponse(httpResponseBody, "GetExtendedAgentCard");
                this.agentCard = (AgentCard)response.getResult();
                this.needsExtendedCard = false;
                return this.agentCard;
            }
            catch (JsonProcessingException | IOException | InterruptedException e) {
                throw new A2AClientException("Failed to get authenticated extended agent card: " + String.valueOf(e), e);
            }
        }
        catch (A2AClientError e) {
            throw new A2AClientException("Failed to get agent card: " + String.valueOf((Object)e), (Throwable)e);
        }
    }

    public void close() {
    }

    private PayloadAndHeaders applyInterceptors(String methodName, @Nullable Object payload, @Nullable AgentCard agentCard, @Nullable ClientCallContext clientCallContext) {
        PayloadAndHeaders payloadAndHeaders = new PayloadAndHeaders(payload, this.getHttpHeaders(clientCallContext));
        if (this.interceptors != null && !this.interceptors.isEmpty()) {
            for (ClientCallInterceptor interceptor : this.interceptors) {
                payloadAndHeaders = interceptor.intercept(methodName, payloadAndHeaders.getPayload(), payloadAndHeaders.getHeaders(), agentCard, clientCallContext);
            }
        }
        return payloadAndHeaders;
    }

    private String sendPostRequest(String url, PayloadAndHeaders payloadAndHeaders, String method) throws IOException, InterruptedException, JsonProcessingException {
        A2AHttpClient.PostBuilder builder = this.createPostBuilder(url, payloadAndHeaders, method);
        A2AHttpResponse response = builder.post();
        if (!response.success()) {
            throw new IOException("Request failed " + response.status());
        }
        return response.body();
    }

    private A2AHttpClient.PostBuilder createPostBuilder(String url, PayloadAndHeaders payloadAndHeaders, String method) throws JsonProcessingException {
        A2AHttpClient.PostBuilder postBuilder = ((A2AHttpClient.PostBuilder)((A2AHttpClient.PostBuilder)this.httpClient.createPost().url(url)).addHeader("Content-Type", "application/json")).body(JSONRPCUtils.toJsonRPCRequest(null, (String)method, (MessageOrBuilder)((MessageOrBuilder)payloadAndHeaders.getPayload())));
        if (payloadAndHeaders.getHeaders() != null) {
            for (Map.Entry entry : payloadAndHeaders.getHeaders().entrySet()) {
                postBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return postBuilder;
    }

    private <T extends A2AResponse<?>> T unmarshalResponse(String response, String method) throws A2AClientException, JsonProcessingException {
        A2AResponse value = JSONRPCUtils.parseResponseBody((String)response, (String)method);
        A2AError error = value.getError();
        if (error != null) {
            throw new A2AClientException(error.getMessage() + (String)(error.getData() != null ? ": " + String.valueOf(error.getData()) : ""), (Throwable)error);
        }
        return (T)value;
    }

    private @Nullable Map<String, String> getHttpHeaders(@Nullable ClientCallContext context) {
        return context != null ? context.getHeaders() : null;
    }
}

