/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.extras.queuemanager.replicated.mp_reactive;

import io.a2a.extras.queuemanager.replicated.core.ReplicatedEventQueueItem;
import io.a2a.extras.queuemanager.replicated.core.ReplicationStrategy;
import io.a2a.jsonrpc.common.json.JsonUtil;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ReactiveMessagingReplicationStrategy
implements ReplicationStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveMessagingReplicationStrategy.class);
    @Inject
    @Channel(value="replicated-events-out")
    private Emitter<String> emitter;
    @Inject
    private Event<ReplicatedEventQueueItem> cdiEvent;

    public void send(String taskId, io.a2a.spec.Event event) {
        LOGGER.debug("Sending replicated event for task: {}, event: {}", (Object)taskId, (Object)event);
        try {
            ReplicatedEventQueueItem replicatedEvent = new ReplicatedEventQueueItem(taskId, event);
            String json = JsonUtil.toJson((Object)replicatedEvent);
            this.emitter.send((Object)json);
            LOGGER.debug("Successfully sent replicated event for task: {}", (Object)taskId);
        }
        catch (Exception e) {
            LOGGER.error("Failed to send replicated event for task: {}, event: {}", new Object[]{taskId, event, e});
            throw new RuntimeException("Failed to send replicated event", e);
        }
    }

    @Incoming(value="replicated-events-in")
    public void onReplicatedEvent(String jsonMessage) {
        LOGGER.debug("Received replicated event JSON: {}", (Object)jsonMessage);
        try {
            ReplicatedEventQueueItem replicatedEvent = (ReplicatedEventQueueItem)JsonUtil.fromJson((String)jsonMessage, ReplicatedEventQueueItem.class);
            LOGGER.debug("Deserialized replicated event for task: {}, event: {}", (Object)replicatedEvent.getTaskId(), (Object)replicatedEvent.getEvent());
            this.cdiEvent.fire((Object)replicatedEvent);
            LOGGER.debug("Successfully fired CDI event for task: {}", (Object)replicatedEvent.getTaskId());
        }
        catch (Exception e) {
            LOGGER.error("Failed to deserialize replicated event from JSON: {}", (Object)jsonMessage, (Object)e);
        }
    }
}

