/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.extras.queuemanager.replicated.core;

import io.a2a.server.events.EventQueueItem;
import io.a2a.server.events.QueueClosedEvent;
import io.a2a.spec.A2AError;
import io.a2a.spec.Event;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.Task;

public class ReplicatedEventQueueItem
implements EventQueueItem {
    private String taskId;
    private StreamingEventKind event;
    private A2AError error;
    private boolean closedEvent;

    public ReplicatedEventQueueItem() {
    }

    public ReplicatedEventQueueItem(String taskId, StreamingEventKind event) {
        this.taskId = taskId;
        this.event = event;
        this.error = null;
    }

    public ReplicatedEventQueueItem(String taskId, A2AError error) {
        this.taskId = taskId;
        this.event = null;
        this.error = error;
    }

    public ReplicatedEventQueueItem(String taskId, Event event) {
        this.taskId = taskId;
        if (event instanceof QueueClosedEvent) {
            this.event = null;
            this.error = null;
            this.closedEvent = true;
        } else if (event instanceof StreamingEventKind) {
            StreamingEventKind streamingEvent;
            this.event = streamingEvent = (StreamingEventKind)event;
            this.error = null;
            this.closedEvent = false;
        } else if (event instanceof A2AError) {
            A2AError jsonRpcError = (A2AError)event;
            this.event = null;
            this.error = jsonRpcError;
            this.closedEvent = false;
        } else {
            throw new IllegalArgumentException("Event must be StreamingEventKind, A2AError, or QueueClosedEvent, got: " + String.valueOf(event.getClass()));
        }
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public StreamingEventKind getStreamingEvent() {
        return this.event;
    }

    public void setEvent(StreamingEventKind event) {
        this.event = event;
        this.error = null;
    }

    public A2AError getErrorObject() {
        return this.error;
    }

    public void setError(A2AError error) {
        this.error = error;
        this.event = null;
    }

    public Event getEvent() {
        if (this.closedEvent) {
            return new QueueClosedEvent(this.taskId);
        }
        if (this.event != null) {
            return this.event;
        }
        return this.error;
    }

    public boolean isReplicated() {
        return true;
    }

    public boolean hasEvent() {
        return this.event != null;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public boolean isClosedEvent() {
        return this.closedEvent;
    }

    public void setClosedEvent(boolean closedEvent) {
        this.closedEvent = closedEvent;
        if (closedEvent) {
            this.event = null;
            this.error = null;
        }
    }

    public boolean isTaskEvent() {
        return this.event instanceof Task;
    }

    public String toString() {
        return "ReplicatedEventQueueItem{taskId='" + this.taskId + "', event=" + String.valueOf(this.event) + ", error=" + String.valueOf(this.error) + ", closedEvent=" + this.closedEvent + "}";
    }
}

