/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.extras.taskstore.database.jpa;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import io.a2a.spec.Task;
import io.a2a.util.Utils;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;

@Entity
@Table(name="a2a_tasks")
public class JpaTask {
    @Id
    @Column(name="task_id")
    private String id;
    @Column(name="task_data", columnDefinition="TEXT", nullable=false)
    private String taskJson;
    @Transient
    private Task task;

    public JpaTask() {
    }

    public JpaTask(String id, String taskJson) {
        this.id = id;
        this.taskJson = taskJson;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTaskJson() {
        return this.taskJson;
    }

    public void setTaskJson(String taskJson) {
        this.taskJson = taskJson;
    }

    public Task getTask() throws JsonProcessingException {
        if (this.task == null) {
            this.task = (Task)Utils.unmarshalFrom((String)this.taskJson, (TypeReference)Task.TYPE_REFERENCE);
        }
        return this.task;
    }

    public void setTask(Task task) throws JsonProcessingException {
        this.taskJson = Utils.OBJECT_MAPPER.writeValueAsString((Object)task);
        if (this.id == null) {
            this.id = task.getId();
        }
        this.task = task;
    }

    static JpaTask createFromTask(Task task) throws JsonProcessingException {
        String json = Utils.OBJECT_MAPPER.writeValueAsString((Object)task);
        JpaTask jpaTask = new JpaTask(task.getId(), json);
        jpaTask.task = task;
        return jpaTask;
    }
}

