/*
 * Decompiled with CFR 0.152.
 */
package com.ct.condition.core;

import com.ct.condition.core.Handler;
import com.ct.condition.core.JpaPlusException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

final class SpecificationFactory {
    SpecificationFactory() {
    }

    public static <T> Specification<T> createSpec(Handler handler, String fieldName, Object val) {
        if (fieldName == null) {
            throw JpaPlusException.getException("fieldName cannot be null");
        }
        if (val == null && handler != Handler.IS_NOT_NULL && handler != Handler.IS_NULL) {
            return null;
        }
        switch (handler) {
            case EQUAL: {
                return (Specification & Serializable)(root, query, cb) -> {
                    Path path = root.get(fieldName);
                    return cb.equal((Expression)path, val);
                };
            }
            case NOT_EQUAL: {
                return (Specification & Serializable)(root, query, cb) -> {
                    Path path = root.get(fieldName);
                    return cb.equal((Expression)path, val).not();
                };
            }
            case GE: {
                return (Specification & Serializable)(root, query, cb) -> {
                    Path path = root.get(fieldName);
                    return cb.greaterThanOrEqualTo((Expression)path, (Comparable)val);
                };
            }
            case GT: {
                return (Specification & Serializable)(root, query, cb) -> {
                    Path path = root.get(fieldName);
                    return cb.greaterThan((Expression)path, (Comparable)val);
                };
            }
            case LE: {
                return (Specification & Serializable)(root, query, cb) -> {
                    Path path = root.get(fieldName);
                    return cb.lessThanOrEqualTo((Expression)path, (Comparable)val);
                };
            }
            case LT: {
                return (Specification & Serializable)(root, query, cb) -> {
                    Path path = root.get(fieldName);
                    return cb.lessThan((Expression)path, (Comparable)val);
                };
            }
            case ALL_LIKE: {
                return (Specification & Serializable)(root, query, cb) -> {
                    Path path = root.get(fieldName);
                    return cb.like((Expression)path, "%" + val + "%");
                };
            }
            case LEFT_LIKE: {
                return (Specification & Serializable)(root, query, cb) -> {
                    Path path = root.get(fieldName);
                    return cb.like((Expression)path, "%" + val);
                };
            }
            case RIGHT_LIKE: {
                return (Specification & Serializable)(root, query, cb) -> {
                    Path path = root.get(fieldName);
                    return cb.like((Expression)path, val + "%");
                };
            }
            case IN: {
                return (Specification & Serializable)(root, query, cb) -> {
                    Path path = SpecificationFactory.parseRootPath(root, fieldName);
                    if (val instanceof Collection) {
                        List notEmptyList = ((Collection)val).stream().filter(Objects::nonNull).collect(Collectors.toList());
                        return path.in(notEmptyList);
                    }
                    throw JpaPlusException.getException("Value Must be Collection Instance!");
                };
            }
            case NOT_IN: {
                return (Specification & Serializable)(root, query, cb) -> {
                    Path path = SpecificationFactory.parseRootPath(root, fieldName);
                    if (val instanceof Collection) {
                        List notEmptyList = ((Collection)val).stream().filter(Objects::nonNull).collect(Collectors.toList());
                        return path.in(notEmptyList).not();
                    }
                    throw JpaPlusException.getException("Value Must be Collection Instance!");
                };
            }
            case IS_NOT_NULL: {
                return (Specification & Serializable)(root, query, cb) -> {
                    Path path = root.get(fieldName);
                    return cb.isNotNull((Expression)path);
                };
            }
            case IS_NULL: {
                return (Specification & Serializable)(root, query, cb) -> {
                    Path path = root.get(fieldName);
                    return cb.isNull((Expression)path);
                };
            }
        }
        return null;
    }

    public static <T> Path parseRootPath(Root<T> root, String attrName) {
        Path path = null;
        if (attrName.indexOf(46) != -1) {
            String[] attrArr = attrName.split("\\.");
            for (int i = 0; i <= attrArr.length - 1; ++i) {
                path = path == null ? root.get(attrArr[i]) : path.get(attrArr[i]);
            }
        } else {
            path = root.get(attrName);
        }
        return path;
    }
}

