/*
 * Decompiled with CFR 0.152.
 */
package io.github.rosemoe.editor.core.util;

import io.github.rosemoe.editor.core.util.Logger;
import java.util.Map;
import java.util.Set;

public class CallStack {
    public static String getLastCaller() {
        return CallStack.getLastCaller(Thread.getAllStackTraces().entrySet());
    }

    public static String getLastCaller(Integer off) {
        return CallStack.getLastCaller(Thread.getAllStackTraces().entrySet());
    }

    private static String getLastCaller(Set<Map.Entry<Thread, StackTraceElement[]>> set) {
        String c = "\u00a7";
        for (Map.Entry<Thread, StackTraceElement[]> entry : set) {
            if (entry.getKey() != Thread.currentThread()) continue;
            for (StackTraceElement ste : entry.getValue()) {
                String classname = ste.getClassName();
                String methodname = ste.getMethodName();
                if (classname.lastIndexOf("io.github.rosemoe.editor") == -1 && classname.lastIndexOf("org.antlr.v4") == -1 || classname.lastIndexOf(".util.Logger") != -1 || classname.lastIndexOf(".util.CallStack") != -1 || methodname.lastIndexOf("dump") != -1) continue;
                return CallStack.clearName(classname) + c + CallStack.clearName(methodname + c + ste.getLineNumber());
            }
        }
        return null;
    }

    private static String clearName(String name) {
        int i = name.lastIndexOf(".");
        if (i == -1) {
            return name;
        }
        return name.substring(i + 1);
    }

    public static void printStackTrace() {
        CallStack.printStackTrace(Thread.getAllStackTraces().entrySet());
    }

    public static void printStackTrace(Set<Map.Entry<Thread, StackTraceElement[]>> set) {
        for (Map.Entry<Thread, StackTraceElement[]> entry : set) {
            if (entry.getKey() != Thread.currentThread()) continue;
            for (StackTraceElement ste : entry.getValue()) {
                Logger.debug("                  ", ste.getClassName(), "\u00a7\u00a7", ste.getMethodName(), "\u00a7\u00a7", ste.getLineNumber());
            }
        }
    }

    public static void printAllStackTrace() {
        CallStack.printAllStackTrace(Thread.getAllStackTraces().entrySet());
    }

    public static void printAllStackTrace(Set<Map.Entry<Thread, StackTraceElement[]>> set) {
        for (Map.Entry<Thread, StackTraceElement[]> entry : set) {
            for (StackTraceElement ste : entry.getValue()) {
                Logger.debug("                  ", ste.getClassName(), "\u00a7\u00a7", ste.getMethodName(), "\u00a7\u00a7", ste.getLineNumber());
            }
        }
    }
}

