/*
 * Decompiled with CFR 0.152.
 */
package io.github.rosemoe.editor.core.interactions;

import com.googlecode.lanterna.gui2.Interactable;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.KeyType;
import com.googlecode.lanterna.input.MouseAction;
import com.googlecode.lanterna.input.MouseActionType;
import io.github.rosemoe.editor.core.CodeEditorView;
import io.github.rosemoe.editor.core.CodeEditorViewTerminal;
import io.github.rosemoe.editor.core.analyze.signal.Routes;
import io.github.rosemoe.editor.core.interactions.Interaction;

public class Keyboard
extends Interaction<CodeEditorViewTerminal> {
    public Keyboard(CodeEditorViewTerminal editor) {
        super((CodeEditorView)editor);
    }

    public void handleRouting(Routes action, Object ... args) {
        ((CodeEditorViewTerminal)this.editor).handleRouting(action, args);
    }

    public Interactable.Result onKeyDown(KeyStroke keyStroke) {
        switch (keyStroke.getKeyType()) {
            case Tab: {
                this.handleRouting(Routes.ACTION_CURSOR, Routes.TAB);
                break;
            }
            case Delete: {
                this.handleRouting(Routes.ACTION_CURSOR, Routes.DELETE);
                break;
            }
            case ArrowUp: {
                this.handleRouting(Routes.ACTION_CURSOR, Routes.UP);
                break;
            }
            case ArrowDown: {
                this.handleRouting(Routes.ACTION_CURSOR, Routes.DOWN);
                break;
            }
            case ArrowRight: {
                this.handleRouting(Routes.ACTION_CURSOR, Routes.RIGHT);
                break;
            }
            case ArrowLeft: {
                this.handleRouting(Routes.ACTION_CURSOR, Routes.LEFT);
                break;
            }
            case End: {
                this.handleRouting(Routes.ACTION_CURSOR, Routes.END);
                break;
            }
            case Home: {
                this.handleRouting(Routes.ACTION_CURSOR, Routes.HOME);
                break;
            }
            case Character: {
                this.handleRouting(Routes.ACTION_CURSOR, Routes.COMMIT_TEXT, String.valueOf(keyStroke.getCharacter()));
                break;
            }
            case Enter: {
                this.handleRouting(Routes.ACTION_CURSOR, Routes.ENTER);
                break;
            }
            case Backspace: {
                this.handleRouting(Routes.ACTION_CURSOR, Routes.DELETE_R);
                break;
            }
            case ReverseTab: {
                this.handleRouting(Routes.ACTION_CURSOR, Routes.SHIFT);
                this.handleRouting(Routes.ACTION_CURSOR, Routes.TAB);
                this.handleRouting(Routes.ACTION_CURSOR, Routes.UNSHIFT);
                break;
            }
            case PageDown: {
                this.handleRouting(Routes.ACTION_CURSOR, Routes.PAGE_DOWN);
                break;
            }
            case PageUp: {
                this.handleRouting(Routes.ACTION_CURSOR, Routes.PAGE_UP);
                break;
            }
            case MouseEvent: {
                MouseAction mouseAction = (MouseAction)keyStroke;
                MouseActionType actionType = mouseAction.getActionType();
                switch (actionType) {
                    case SCROLL_DOWN: {
                        this.handleRouting(Routes.ACTION_CURSOR, Routes.DOWN);
                        break;
                    }
                    case SCROLL_UP: {
                        this.handleRouting(Routes.ACTION_CURSOR, Routes.UP);
                    }
                }
                break;
            }
            default: {
                return ((CodeEditorViewTerminal)this.editor).zis.superHandleKeyStroke(keyStroke);
            }
        }
        return ((CodeEditorViewTerminal)this.editor).zis.superHandleKeyStroke(new KeyStroke(KeyType.Unknown));
    }
}

