/*
 * Decompiled with CFR 0.152.
 */
package io.github.rosemoe.editor.core.extension;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.TextBox;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import io.github.rosemoe.editor.core.Adaptater;
import io.github.rosemoe.editor.core.CodeEditorController;
import io.github.rosemoe.editor.core.Rect;
import io.github.rosemoe.editor.core.analyze.ResultStoreViewTerminal;
import io.github.rosemoe.editor.core.analyze.signal.Routes;
import io.github.rosemoe.editor.core.color.CodeAnalyzerResultColor;
import io.github.rosemoe.editor.core.color.ColorManagerViewTerminal;
import io.github.rosemoe.editor.core.content.CodeAnalyzerResultContent;
import io.github.rosemoe.editor.core.extension.extensions.guiwidgets.scrollbar.ScrollBarViewTerminal;
import io.github.rosemoe.editor.core.grid.Line;

public class TextBoxRendererCustom
implements TextBox.TextBoxRenderer {
    TextBox.TextBoxRenderer tbr;
    final CodeEditorController editor;
    final ColorManagerViewTerminal colorManager;

    public TextBoxRendererCustom(TextBox.TextBoxRenderer init, CodeEditorController editor, ColorManagerViewTerminal colorManager) {
        this.tbr = init;
        this.editor = editor;
        this.colorManager = colorManager;
    }

    public TerminalPosition getCursorLocation(TextBox component) {
        return this.tbr.getCursorLocation((Component)component);
    }

    public TerminalPosition getViewTopLeft() {
        return this.tbr.getViewTopLeft();
    }

    public void setViewTopLeft(TerminalPosition position) {
        this.tbr.setViewTopLeft(position);
    }

    public TerminalSize getPreferredSize(TextBox component) {
        return this.tbr.getPreferredSize((Component)component);
    }

    public void drawComponent(TextGUIGraphics textGUIGraphics, TextBox textBox) {
        Rect r;
        ScrollBarViewTerminal scrollBar;
        CodeAnalyzerResultContent content = (CodeAnalyzerResultContent)this.editor.resultStore.getResult("content");
        TerminalSize realTextArea = textGUIGraphics.getSize();
        if (realTextArea.getRows() == 0 || realTextArea.getColumns() == 0) {
            return;
        }
        boolean drawVerticalScrollBar = false;
        boolean drawHorizontalScrollBar = false;
        int textBoxLineCount = textBox.getLineCount();
        if (textBoxLineCount > realTextArea.getRows() && realTextArea.getColumns() > 1) {
            realTextArea = realTextArea.withRelativeColumns(-1);
            if (this.editor.verticalScrollBar.hasOption(1)) {
                drawVerticalScrollBar = true;
            }
        }
        if (content.longestLineWidth() > realTextArea.getColumns() && realTextArea.getRows() > 1) {
            realTextArea = realTextArea.withRelativeRows(-1);
            if (this.editor.horizontalScrollBar.hasOption(1)) {
                drawHorizontalScrollBar = true;
            }
            if (textBoxLineCount > realTextArea.getRows() && !drawVerticalScrollBar) {
                realTextArea = realTextArea.withRelativeColumns(-1);
                if (this.editor.verticalScrollBar.hasOption(1)) {
                    drawVerticalScrollBar = true;
                }
            }
        }
        if (this.editor.verticalScrollBar.hasOption(2)) {
            drawVerticalScrollBar = true;
        }
        if (this.editor.horizontalScrollBar.hasOption(2)) {
            drawHorizontalScrollBar = true;
        }
        drawHorizontalScrollBar = drawHorizontalScrollBar && this.editor.horizontalScrollBar.isEnabled();
        drawVerticalScrollBar = drawVerticalScrollBar && this.editor.verticalScrollBar.isEnabled();
        this.drawTextArea(textGUIGraphics, textBox);
        if (drawVerticalScrollBar) {
            scrollBar = (ScrollBarViewTerminal)this.editor.verticalScrollBar.view;
            r = Adaptater.getRect(textGUIGraphics.getSize().getColumns() - ((ScrollBarViewTerminal)this.editor.verticalScrollBar.view).getWidth(), 0, ((ScrollBarViewTerminal)this.editor.verticalScrollBar.view).getWidth(), textGUIGraphics.getSize().getRows() - (drawHorizontalScrollBar ? ((ScrollBarViewTerminal)this.editor.horizontalScrollBar.view).getWidth() : 0));
            scrollBar.draw(r, textGUIGraphics, textBox);
        }
        if (drawHorizontalScrollBar) {
            scrollBar = (ScrollBarViewTerminal)this.editor.horizontalScrollBar.view;
            r = Adaptater.getRect(0, textGUIGraphics.getSize().getRows() - ((ScrollBarViewTerminal)this.editor.horizontalScrollBar.view).getWidth(), textGUIGraphics.getSize().getColumns() - (drawVerticalScrollBar ? ((ScrollBarViewTerminal)this.editor.verticalScrollBar.view).getWidth() : 0), ((ScrollBarViewTerminal)this.editor.horizontalScrollBar.view).getWidth());
            scrollBar.draw(r, textGUIGraphics, textBox);
        }
    }

    public void drawTextArea(TextGUIGraphics textGUIGraphics, TextBox textBox) {
        TerminalPosition scrollTo;
        CodeAnalyzerResultContent content = (CodeAnalyzerResultContent)this.editor.resultStore.getResult("content");
        CodeAnalyzerResultColor color = (CodeAnalyzerResultColor)this.editor.resultStore.getResult("color");
        TerminalSize textAreaSize = textGUIGraphics.getSize();
        Line l = content.get((Object)this.getViewTopLeft().getRow());
        int rowWidth = 0;
        if (l != null) {
            rowWidth = l.getWidth();
        }
        if ((scrollTo = this.getViewTopLeft()).getColumn() + textAreaSize.getColumns() > rowWidth && (scrollTo = scrollTo.withColumn(rowWidth - textAreaSize.getColumns())).getColumn() < 0) {
            scrollTo = scrollTo.withColumn(0);
        }
        if (scrollTo.getRow() + textAreaSize.getRows() > textBox.getLineCount() && (scrollTo = scrollTo.withRow(textBox.getLineCount() - textAreaSize.getRows())).getRow() < 0) {
            scrollTo = scrollTo.withRow(0);
        }
        ThemeDefinition themeDefinition = textBox.getThemeDefinition();
        if (textBox.isFocused()) {
            if (textBox.isReadOnly()) {
                textGUIGraphics.applyThemeStyle(themeDefinition.getSelected());
            } else {
                textGUIGraphics.applyThemeStyle(themeDefinition.getActive());
            }
        } else if (textBox.isReadOnly()) {
            textGUIGraphics.applyThemeStyle(themeDefinition.getInsensitive());
        } else {
            textGUIGraphics.applyThemeStyle(themeDefinition.getNormal());
        }
        textGUIGraphics.setBackgroundColor(this.colorManager.getColor("wholeBackground"));
        Character fillCharacter = Character.valueOf(' ');
        textGUIGraphics.fill(fillCharacter.charValue());
        if (!textBox.isReadOnly()) {
            TerminalPosition caretPosition = textBox.getCaretPosition();
            String caretLine = textBox.getLine(caretPosition.getRow());
            int trueColumnPosition = TerminalTextUtils.getColumnIndex((String)caretLine, (int)(caretPosition = caretPosition.withColumn(Math.min(caretPosition.getColumn(), caretLine.length()))).getColumn());
            if (trueColumnPosition < scrollTo.getColumn()) {
                scrollTo = scrollTo.withColumn(trueColumnPosition);
            } else if (trueColumnPosition >= textAreaSize.getColumns() + scrollTo.getColumn()) {
                scrollTo = scrollTo.withColumn(trueColumnPosition - textAreaSize.getColumns() + 1);
            }
            if (caretPosition.getRow() < scrollTo.getRow()) {
                scrollTo = scrollTo.withRow(caretPosition.getRow());
            } else if (caretPosition.getRow() >= textAreaSize.getRows() + scrollTo.getRow()) {
                scrollTo = scrollTo.withRow(caretPosition.getRow() - textAreaSize.getRows() + 1);
            }
            if (trueColumnPosition - scrollTo.getColumn() == textGUIGraphics.getSize().getColumns() - 1 && caretLine.length() > caretPosition.getColumn() && TerminalTextUtils.isCharCJK((char)caretLine.charAt(caretPosition.getColumn()))) {
                scrollTo = scrollTo.withRelativeColumn(1);
            }
        }
        if (!scrollTo.equals((Object)this.getViewTopLeft())) {
            this.editor.routing(Routes.ACTION_SCROLL, new Object[]{Routes.TO, scrollTo.getColumn(), scrollTo.getRow()});
        }
        ResultStoreViewTerminal rsvt = (ResultStoreViewTerminal)this.editor.resultStoreView;
        rsvt.viewTopLeft = this.getViewTopLeft();
        rsvt.textAreaSize = textAreaSize;
        rsvt.textGUIGraphics = textGUIGraphics;
        this.editor.draw();
    }
}

