/*
 * Decompiled with CFR 0.152.
 */
package io.github.rosemoe.editor.core.analyze;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import io.github.rosemoe.editor.core.analyze.ResultStoreView;
import io.github.rosemoe.editor.core.analyze.result.AnalyzerResultView;
import io.github.rosemoe.editor.core.color.ColorManagerViewTerminal;
import io.github.rosemoe.editor.core.color.grid.SpanCell;
import io.github.rosemoe.editor.core.content.grid.ContentCell;
import io.github.rosemoe.editor.core.grid.CellPosition;

public class ResultStoreViewTerminal
extends ResultStoreView {
    public TerminalPosition viewTopLeft;
    public TerminalSize textAreaSize;
    public TextGUIGraphics textGUIGraphics;

    public ResultStoreViewTerminal() {
        this.colorView = new AnalyzerResultView<SpanCell>(){

            public void apply(SpanCell cell, CellPosition cp) {
                ResultStoreViewTerminal.this.textGUIGraphics.setForegroundColor(ColorManagerViewTerminal.integerToAnsi(cell.color));
            }

            public void unapply(SpanCell cell, CellPosition cp) {
                ResultStoreViewTerminal.this.textGUIGraphics.setForegroundColor(null);
            }
        };
        this.contentView = new AnalyzerResultView<ContentCell>(){

            public void apply(ContentCell cell, CellPosition cp) {
                for (int a = 0; a < cell.c.length; ++a) {
                    ResultStoreViewTerminal.this.textGUIGraphics.setCharacter(cp.column - ResultStoreViewTerminal.this.viewTopLeft.getColumn() + a, cp.line - ResultStoreViewTerminal.this.viewTopLeft.getRow(), cell.c[a]);
                }
            }

            public void unapply(ContentCell cell, CellPosition cp) {
            }
        };
    }
}

