/*
 * Decompiled with CFR 0.152.
 */
package io.github.rosemoe.editor.core;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.graphics.DelegatingTheme;
import com.googlecode.lanterna.graphics.Theme;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.gui2.AbsoluteLayout;
import com.googlecode.lanterna.gui2.BasicWindow;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.Interactable;
import com.googlecode.lanterna.gui2.LayoutManager;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.gui2.TextBox;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.terminal.Terminal;
import io.github.rosemoe.editor.core.CodeEditorController;
import io.github.rosemoe.editor.core.CodeEditorView;
import io.github.rosemoe.editor.core.analyze.ResultStoreViewTerminal;
import io.github.rosemoe.editor.core.analyze.signal.Routes;
import io.github.rosemoe.editor.core.color.ColorManagerViewTerminal;
import io.github.rosemoe.editor.core.color.MThemeDefinition;
import io.github.rosemoe.editor.core.content.CodeAnalyzerResultContent;
import io.github.rosemoe.editor.core.extension.TextBoxCustom;
import io.github.rosemoe.editor.core.extension.extensions.guiwidgets.WidgetView;
import io.github.rosemoe.editor.core.extension.extensions.guiwidgets.cursor.CursorView;
import io.github.rosemoe.editor.core.extension.extensions.guiwidgets.scrollbar.ScrollBarViewTerminal;
import io.github.rosemoe.editor.core.grid.CellPosition;
import io.github.rosemoe.editor.core.interactions.Keyboard;
import io.github.rosemoe.editor.core.util.Logger;
import java.io.IOException;
import java.util.Arrays;

public class CodeEditorViewTerminal
extends BasicWindow
implements CodeEditorView<Integer>,
WidgetView {
    public CodeEditorController editor;
    public ThemeDefinition tdd;
    public TextBoxCustom zis;
    public final Terminal terminal;
    private final Keyboard keyboard;

    public CodeEditorViewTerminal(Terminal terminal, CodeEditorController controller) {
        this.terminal = terminal;
        this.editor = controller;
        this.editor.resultStoreView = new ResultStoreViewTerminal();
        this.zis = new TextBoxCustom(TextBox.Style.MULTI_LINE, terminal, controller){

            public synchronized Interactable.Result handleKeyStroke(KeyStroke keyStroke) {
                return CodeEditorViewTerminal.this.keyboard.onKeyDown(keyStroke);
            }
        };
        this.keyboard = new Keyboard(this);
    }

    public void inputString(String s) {
        for (char c : s.toCharArray()) {
            this.handleInput(new KeyStroke(Character.valueOf(c), false, false));
        }
    }

    public static CodeEditorController newInstance(final Terminal terminal) {
        CodeEditorController controller = null;
        try {
            controller = new CodeEditorController();
            final CodeEditorViewTerminal view = new CodeEditorViewTerminal(terminal, controller);
            assert (view != null);
            view.setHints(Arrays.asList(Window.Hint.FULL_SCREEN, Window.Hint.NO_DECORATIONS));
            Panel p = new Panel();
            p.setSize(terminal.getTerminalSize());
            p.setLayoutManager((LayoutManager)new AbsoluteLayout());
            view.tdd = new MThemeDefinition(view.zis.getThemeDefinition(), controller.colorManager);
            view.zis.setTheme((Theme)new DelegatingTheme(view.zis.getTheme()){

                public ThemeDefinition getDefinition(Class<?> clazz) {
                    return view.tdd;
                }
            });
            view.zis.setSize(terminal.getTerminalSize());
            p.addComponent((Component)view.zis);
            view.setComponent((Component)p);
            view.editor = controller;
            controller.view = view;
            controller.cursor.attachView((WidgetView)new CursorView(controller.cursor, view.zis){

                @Override
                public void setEnabled(boolean state) {
                    Logger.debug("change cursor view called");
                    try {
                        terminal.setCursorVisible(state);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            assert (controller.view != null);
            view.zis.colorManager = new ColorManagerViewTerminal(controller.colorManager);
            controller.verticalScrollBar.attachView((WidgetView)new ScrollBarViewTerminal(controller, view.zis));
            controller.horizontalScrollBar.attachView((WidgetView)new ScrollBarViewTerminal(controller, view.zis));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return controller;
    }

    public void setEnabled(boolean state) {
    }

    public void update() {
        CodeAnalyzerResultContent content = (CodeAnalyzerResultContent)this.editor.resultStore.getResult("content");
        String newContent = content.toString();
        this.zis.setText(newContent);
    }

    public void clear() {
    }

    public void update(int newLine, int newColumn) {
        this.update();
        this.zis.getRenderer().setViewTopLeft(new TerminalPosition(newColumn, newLine));
    }

    public int getPageSizeRow() {
        try {
            TerminalSize ts = this.zis.terminal.getTerminalSize();
            return ts.getRows() - Integer.valueOf(((ScrollBarViewTerminal)this.editor.horizontalScrollBar.view).getWidth());
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getPageSizeColumn() {
        try {
            TerminalSize ts = this.zis.terminal.getTerminalSize();
            return ts.getColumns() - Integer.valueOf(((ScrollBarViewTerminal)this.editor.horizontalScrollBar.view).getWidth());
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean handleRouting(Routes action, Object ... args) {
        return this.editor.routing(action, args);
    }

    public int getRowHeight() {
        return 1;
    }

    public Integer getColumnWidth() {
        return 1;
    }

    public void scrollTo(int x, int y) {
        this.zis.getRenderer().setViewTopLeft(new TerminalPosition(x, y));
    }

    public CellPosition getViewableStart() {
        return new CellPosition(0, 0);
    }

    public CellPosition getViewableStop() {
        return new CellPosition(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }
}

