/*
 * Decompiled with CFR 0.152.
 */
package org.tron.trident.abi.datatypes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.tron.trident.abi.datatypes.AbiTypes;
import org.tron.trident.abi.datatypes.StaticArray;
import org.tron.trident.abi.datatypes.StructType;
import org.tron.trident.abi.datatypes.Type;

public class StaticStruct
extends StaticArray<Type>
implements StructType {
    private final List<Class<Type>> itemTypes = new ArrayList<Class<Type>>();

    public StaticStruct(List<Type> values) {
        super(Type.class, values.size(), values);
        for (Type value : values) {
            this.itemTypes.add(value.getClass());
        }
    }

    @SafeVarargs
    public StaticStruct(Type ... values) {
        this(Arrays.asList(values));
    }

    @Override
    public String getTypeAsString() {
        StringBuilder type = new StringBuilder("(");
        for (int i = 0; i < this.itemTypes.size(); ++i) {
            Class<Type> cls = this.itemTypes.get(i);
            if (StructType.class.isAssignableFrom(cls)) {
                type.append(((Type)this.getValue().get(i)).getTypeAsString());
            } else {
                type.append(AbiTypes.getTypeAString(cls));
            }
            if (i >= this.itemTypes.size() - 1) continue;
            type.append(",");
        }
        type.append(")");
        return type.toString();
    }
}

