/*
 * Decompiled with CFR 0.152.
 */
package org.mx;

import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.mx.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassUtils {
    private static final Logger logger = LoggerFactory.getLogger(ClassUtils.class);

    private ClassUtils() {
    }

    public static List<String> scanPackage(String packageName) {
        return ClassUtils.scanPackage(packageName, true, true);
    }

    public static void scanPackage(String packageName, Consumer<String> action) {
        ClassUtils.scanPackage(packageName, true, true, action);
    }

    public static List<String> scanPackage(String packageName, boolean recurse, boolean ignoreInlineClass) {
        ArrayList<String> list = new ArrayList<String>();
        ClassUtils.scanPackage(packageName, recurse, ignoreInlineClass, list::add);
        return list;
    }

    public static void scanPackage(String packageName, boolean recurse, boolean ignoreInlineClass, Consumer<String> action) {
        block13: {
            if (StringUtils.isBlank(packageName)) {
                packageName = "";
            }
            packageName = packageName.replaceAll("\\.", "/");
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Enumeration<URL> urls = loader.getResources(packageName);
                block10: while (urls.hasMoreElements()) {
                    String protocol;
                    URL url = urls.nextElement();
                    switch (protocol = url.getProtocol()) {
                        case "jar": {
                            ClassUtils.scanPackageByJar(url.getPath(), recurse, ignoreInlineClass, action);
                            continue block10;
                        }
                        case "file": {
                            String path = url.getPath();
                            String root = path.substring(0, path.length() - packageName.length());
                            if (System.getProperty("os.name").toUpperCase().contains("WINDOWS")) {
                                path = path.substring(1);
                                root = root.substring(1);
                            }
                            ClassUtils.scanPackageByFile(Paths.get(path, new String[0]), root, packageName, recurse, ignoreInlineClass, action);
                            continue block10;
                        }
                    }
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn(String.format("Not supported protocol: %s.", protocol));
                }
            }
            catch (IOException ex) {
                if (!logger.isErrorEnabled()) break block13;
                logger.error(String.format("Get url[%s] resource fail.", packageName), (Throwable)ex);
            }
        }
    }

    private static void scanPackageByFile(Path path, final String root, final String packageName, final boolean recurse, final boolean ignoreInlineClass, final Consumer<String> action) {
        block2: {
            try {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        String file = dir.toString();
                        return recurse || packageName.equals(file.substring(root.length())) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                        String file = path.toString();
                        if (Files.isRegularFile(path, new LinkOption[0]) && file.endsWith(".class") && (!ignoreInlineClass || !file.contains("$"))) {
                            String classPath = file;
                            classPath = classPath.substring(root.length(), classPath.length() - ".class".length());
                            action.accept(classPath.replaceAll("[/\\\\]", "\\."));
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException ex) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error(String.format("Scan package by file fail, path: %s.", path.toFile().getAbsolutePath()));
            }
        }
    }

    private static void scanPackageByJar(String path, boolean recurse, boolean ignoreInlineClass, Consumer<String> action) {
        block20: {
            String[] jarInfo = StringUtils.split(path, "!", true, true);
            if (jarInfo.length == 2) {
                String jarFile = jarInfo[0].substring(jarInfo[0].indexOf("/"));
                String packagePath = jarInfo[1].substring(1);
                try (JarFile jar = new JarFile(jarFile);){
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String entryName = entry.getName();
                        if (!entryName.endsWith(".class") || ignoreInlineClass && entryName.contains("$")) continue;
                        entryName = entryName.substring(0, entryName.length() - ".class".length());
                        if (recurse) {
                            if (!entryName.startsWith(packagePath)) continue;
                            action.accept(entryName.replaceAll("/", "."));
                            continue;
                        }
                        int index = entryName.lastIndexOf(47);
                        String check = entryName;
                        if (index != -1) {
                            check = entryName.substring(0, index);
                        }
                        if (!check.equals(packagePath)) continue;
                        action.accept(entryName);
                    }
                    break block20;
                }
                catch (Exception ex) {
                    if (logger.isErrorEnabled()) {
                        logger.error(String.format("Operate the jar file[%s] fail.", jarFile), (Throwable)ex);
                    }
                    break block20;
                }
            }
            if (logger.isWarnEnabled()) {
                logger.warn(String.format("The path[%s] is not a valid jar file path.", path));
            }
        }
    }
}

