/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.strategy;

import io.getunleash.UnleashContext;
import io.getunleash.strategy.Strategy;
import io.getunleash.strategy.StrategyUtils;
import java.util.Map;
import java.util.Optional;

public final class GradualRolloutSessionIdStrategy
implements Strategy {
    protected static final String PERCENTAGE = "percentage";
    protected static final String GROUP_ID = "groupId";
    private static final String NAME = "gradualRolloutSessionId";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isEnabled(Map<String, String> parameters) {
        return false;
    }

    @Override
    public boolean isEnabled(Map<String, String> parameters, UnleashContext unleashContext) {
        Optional<String> sessionId = unleashContext.getSessionId();
        if (!sessionId.isPresent()) {
            return false;
        }
        int percentage = StrategyUtils.getPercentage(parameters.get(PERCENTAGE));
        String groupId = parameters.getOrDefault(GROUP_ID, "");
        int normalizedSessionId = StrategyUtils.getNormalizedNumber(sessionId.get(), groupId, 0L);
        return percentage > 0 && normalizedSessionId <= percentage;
    }
}

