/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.strategy;

import io.getunleash.Constraint;
import io.getunleash.Operator;
import io.getunleash.UnleashContext;
import io.getunleash.lang.Nullable;
import io.getunleash.strategy.constraints.ConstraintOperator;
import io.getunleash.strategy.constraints.DateConstraintOperator;
import io.getunleash.strategy.constraints.NumberConstraintOperator;
import io.getunleash.strategy.constraints.SemverConstraintOperator;
import io.getunleash.strategy.constraints.StringConstraintOperator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ConstraintUtil {
    private static final Map<Operator, ConstraintOperator> operators = new HashMap<Operator, ConstraintOperator>();

    public static boolean validate(@Nullable List<Constraint> constraints, UnleashContext context) {
        if (constraints != null && constraints.size() > 0) {
            return constraints.stream().allMatch(c -> ConstraintUtil.validateConstraint(c, context));
        }
        return true;
    }

    private static boolean validateConstraint(Constraint constraint, UnleashContext context) {
        ConstraintOperator operator = operators.get((Object)constraint.getOperator());
        if (operator == null) {
            return false;
        }
        return constraint.isInverted() ^ operator.evaluate(constraint, context);
    }

    static {
        operators.put(Operator.STR_CONTAINS, new StringConstraintOperator(Locale.ROOT));
        operators.put(Operator.STR_ENDS_WITH, new StringConstraintOperator(Locale.ROOT));
        operators.put(Operator.STR_STARTS_WITH, new StringConstraintOperator(Locale.ROOT));
        operators.put(Operator.IN, new StringConstraintOperator(Locale.ROOT));
        operators.put(Operator.NOT_IN, new StringConstraintOperator(Locale.ROOT));
        operators.put(Operator.NUM_LT, new NumberConstraintOperator());
        operators.put(Operator.NUM_LTE, new NumberConstraintOperator());
        operators.put(Operator.NUM_EQ, new NumberConstraintOperator());
        operators.put(Operator.NUM_GTE, new NumberConstraintOperator());
        operators.put(Operator.NUM_GT, new NumberConstraintOperator());
        operators.put(Operator.SEMVER_LT, new SemverConstraintOperator());
        operators.put(Operator.SEMVER_EQ, new SemverConstraintOperator());
        operators.put(Operator.SEMVER_GT, new SemverConstraintOperator());
        operators.put(Operator.DATE_BEFORE, new DateConstraintOperator());
        operators.put(Operator.DATE_AFTER, new DateConstraintOperator());
    }
}

