/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.repository;

import io.getunleash.UnleashException;
import io.getunleash.repository.FeatureToggleResponse;
import io.getunleash.repository.JsonToggleParser;
import io.getunleash.repository.ToggleCollection;
import io.getunleash.repository.ToggleFetcher;
import io.getunleash.util.UnleashConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpToggleFetcher
implements ToggleFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(HttpToggleFetcher.class);
    private static final int CONNECT_TIMEOUT = 10000;
    private Optional<String> etag = Optional.empty();
    private final URL toggleUrl;
    private final UnleashConfig unleashConfig;

    public HttpToggleFetcher(UnleashConfig unleashConfig) {
        this.unleashConfig = unleashConfig;
        this.toggleUrl = unleashConfig.getUnleashURLs().getFetchTogglesURL(unleashConfig.getProjectName(), unleashConfig.getNamePrefix());
    }

    @Override
    public FeatureToggleResponse fetchToggles() throws UnleashException {
        HttpURLConnection connection = null;
        try {
            connection = this.openConnection(this.toggleUrl);
            connection.connect();
            FeatureToggleResponse featureToggleResponse = this.getToggleResponse(connection, true);
            return featureToggleResponse;
        }
        catch (IOException e) {
            throw new UnleashException("Could not fetch toggles", e);
        }
        catch (IllegalStateException e) {
            throw new UnleashException(e.getMessage(), e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private FeatureToggleResponse getToggleResponse(HttpURLConnection request, boolean followRedirect) throws IOException {
        int responseCode = request.getResponseCode();
        if (responseCode < 300) {
            this.etag = Optional.ofNullable(request.getHeaderField("ETag"));
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getContent(), StandardCharsets.UTF_8));){
                ToggleCollection toggles = JsonToggleParser.fromJson(reader);
                FeatureToggleResponse featureToggleResponse = new FeatureToggleResponse(FeatureToggleResponse.Status.CHANGED, toggles);
                return featureToggleResponse;
            }
        }
        if (followRedirect && (responseCode == 302 || responseCode == 301 || responseCode == 303)) {
            return this.followRedirect(request);
        }
        if (responseCode == 304) {
            return new FeatureToggleResponse(FeatureToggleResponse.Status.NOT_CHANGED, responseCode);
        }
        return new FeatureToggleResponse(FeatureToggleResponse.Status.UNAVAILABLE, responseCode, this.getLocationHeader(request));
    }

    private FeatureToggleResponse followRedirect(HttpURLConnection request) throws IOException {
        String newUrl = this.getLocationHeader(request);
        request = this.openConnection(new URL(newUrl));
        request.connect();
        LOG.info("Redirecting from {} to {}. Please consider to update your config.", (Object)this.toggleUrl, (Object)newUrl);
        return this.getToggleResponse(request, false);
    }

    private String getLocationHeader(HttpURLConnection connection) {
        return connection.getHeaderField("Location");
    }

    private HttpURLConnection openConnection(URL url) throws IOException {
        HttpURLConnection connection = this.unleashConfig.getProxy() != null ? (HttpURLConnection)url.openConnection(this.unleashConfig.getProxy()) : (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(10000);
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Content-Type", "application/json");
        UnleashConfig.setRequestProperties(connection, this.unleashConfig);
        this.etag.ifPresent(val -> connection.setRequestProperty("If-None-Match", (String)val));
        connection.setUseCaches(true);
        return connection;
    }
}

