/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.metric;

import io.getunleash.engine.MetricsBucket;
import io.getunleash.engine.UnleashEngine;
import io.getunleash.metric.ClientMetrics;
import io.getunleash.metric.ClientRegistration;
import io.getunleash.metric.MetricSender;
import io.getunleash.metric.UnleashMetricService;
import io.getunleash.util.Throttler;
import io.getunleash.util.UnleashConfig;
import io.getunleash.util.UnleashScheduledExecutor;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Set;

public class UnleashMetricServiceImpl
implements UnleashMetricService {
    private final LocalDateTime started = LocalDateTime.now(ZoneId.of("UTC"));
    private final UnleashConfig unleashConfig;
    private final MetricSender metricSender;
    private final UnleashEngine engine;
    private final Throttler throttler;

    public UnleashMetricServiceImpl(UnleashConfig unleashConfig, UnleashScheduledExecutor executor, UnleashEngine engine) {
        this(unleashConfig, (MetricSender)unleashConfig.getMetricSenderFactory().apply(unleashConfig), executor, engine);
    }

    public UnleashMetricServiceImpl(UnleashConfig unleashConfig, MetricSender metricSender, UnleashScheduledExecutor executor, UnleashEngine engine) {
        this.unleashConfig = unleashConfig;
        this.metricSender = metricSender;
        this.throttler = new Throttler((int)unleashConfig.getSendMetricsInterval(), 300, unleashConfig.getUnleashURLs().getClientMetricsURL());
        this.engine = engine;
        long metricsInterval = unleashConfig.getSendMetricsInterval();
        executor.setInterval(this.sendMetrics(), metricsInterval, metricsInterval);
    }

    @Override
    public void register(Set<String> strategies) {
        ClientRegistration registration = new ClientRegistration(this.unleashConfig, this.started, strategies);
        this.metricSender.registerClient(registration);
    }

    private Runnable sendMetrics() {
        return () -> {
            if (this.throttler.performAction()) {
                MetricsBucket bucket = this.engine.getMetrics();
                ClientMetrics metrics = new ClientMetrics(this.unleashConfig, bucket);
                int statusCode = this.metricSender.sendMetrics(metrics);
                if (statusCode >= 200 && statusCode < 400) {
                    this.throttler.decrementFailureCountAndResetSkips();
                }
                if (statusCode >= 400) {
                    this.throttler.handleHttpErrorCodes(statusCode);
                }
            } else {
                this.throttler.skipped();
            }
        };
    }

    protected int getSkips() {
        return this.throttler.getSkips();
    }

    protected int getFailures() {
        return this.throttler.getFailures();
    }
}

