/*
 * Decompiled with CFR 0.152.
 */
package org.unleash.features.aop;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;
import org.unleash.features.annotation.Toggle;
import org.unleash.features.aop.FeatureAdvisor;

@Component(value="feature.autoproxy")
public class FeatureProxyAdvisor
extends AbstractAutoProxyCreator {
    private static final long serialVersionUID = -364406999854610869L;
    private final Map<String, Boolean> processedInterface = new HashMap<String, Boolean>();

    public FeatureProxyAdvisor() {
        this.setInterceptorNames(new String[]{this.getBeanNameOfFeatureAdvisor()});
    }

    private String getBeanNameOfFeatureAdvisor() {
        return FeatureAdvisor.class.getAnnotation(Component.class).value();
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Class<?> beanClass, String beanName, TargetSource targetSource) {
        Class<?>[] interfaces;
        if (!beanClass.isInterface() && (interfaces = ClassUtils.isCglibProxyClass(beanClass) ? beanClass.getSuperclass().getInterfaces() : beanClass.getInterfaces()) != null) {
            for (Class<?> currentInterface : interfaces) {
                Object[] r = this.scanInterface(currentInterface);
                if (r == null) continue;
                return r;
            }
        }
        return DO_NOT_PROXY;
    }

    private Object[] scanInterface(Class<?> currentInterface) {
        String currentInterfaceName = currentInterface.getCanonicalName();
        if (this.isJdkInterface(currentInterfaceName)) {
            return null;
        }
        if (!this.processedInterface.containsKey(currentInterfaceName)) {
            return this.scanInterfaceForAnnotation(currentInterface, currentInterfaceName);
        }
        Boolean isInterfaceFlipped = this.processedInterface.get(currentInterfaceName);
        return isInterfaceFlipped != false ? PROXY_WITHOUT_ADDITIONAL_INTERCEPTORS : null;
    }

    private boolean isJdkInterface(String currentInterfaceName) {
        return currentInterfaceName.startsWith("java.");
    }

    private Object[] scanInterfaceForAnnotation(Class<?> currentInterface, String currentInterfaceName) {
        if (AnnotatedElementUtils.hasAnnotation(currentInterface, Toggle.class)) {
            this.processedInterface.put(currentInterfaceName, true);
            return PROXY_WITHOUT_ADDITIONAL_INTERCEPTORS;
        }
        for (Method method : currentInterface.getDeclaredMethods()) {
            if (!AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, Toggle.class)) continue;
            this.processedInterface.put(currentInterfaceName, true);
            return PROXY_WITHOUT_ADDITIONAL_INTERCEPTORS;
        }
        this.processedInterface.put(currentInterfaceName, false);
        return null;
    }
}

