/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.services.framework;

import io.getstream.chat.java.services.framework.UserServiceFactory;
import io.getstream.chat.java.services.framework.UserServiceFactoryProxy;
import io.getstream.chat.java.services.framework.UserServiceFactoryTagging;
import io.getstream.chat.java.services.framework.UserToken;
import java.util.concurrent.atomic.AtomicReference;
import retrofit2.Retrofit;

final class UserServiceFactorySelector
implements UserServiceFactory {
    private final UserServiceFactory proxyFactory;
    private final UserServiceFactory taggingFactory;
    private final AtomicReference<UserServiceFactory> activeFactory;

    public UserServiceFactorySelector(Retrofit retrofit) {
        this.proxyFactory = new UserServiceFactoryProxy(retrofit);
        this.taggingFactory = new UserServiceFactoryTagging(retrofit);
        UserServiceFactory defaultFactory = this.proxyFactory;
        try {
            Class<?> retrofitCallClass = Class.forName("retrofit2.OkHttpCall");
            retrofitCallClass.getDeclaredField("rawCall");
        }
        catch (Throwable e) {
            defaultFactory = this.taggingFactory;
        }
        this.activeFactory = new AtomicReference<UserServiceFactory>(defaultFactory);
    }

    @Override
    public <TService> TService create(Class<TService> svcClass, UserToken userToken) {
        UserServiceFactory factory = this.activeFactory.get();
        try {
            return factory.create(svcClass, userToken);
        }
        catch (Throwable e) {
            if (factory == this.taggingFactory) {
                throw new RuntimeException("Failed to create service using fallback implementation", e);
            }
            this.activeFactory.compareAndSet(this.proxyFactory, this.taggingFactory);
            try {
                return this.taggingFactory.create(svcClass, userToken);
            }
            catch (Throwable fallbackException) {
                throw new RuntimeException("Failed to create service with both implementations", fallbackException);
            }
        }
    }
}

