/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.getstream.chat.java.exceptions.StreamException;
import io.getstream.chat.java.models.Channel;
import io.getstream.chat.java.models.Draft;
import io.getstream.chat.java.models.Message;
import io.getstream.chat.java.models.Sort;
import io.getstream.chat.java.models.User;
import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.ThreadService;
import io.getstream.chat.java.services.framework.Client;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;

public class Thread {
    @NotNull
    public static QueryThreadsRequestData.QueryThreadsRequest queryThreads() {
        return new QueryThreadsRequestData.QueryThreadsRequest();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Thread)) {
            return false;
        }
        Thread other = (Thread)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof Thread;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "Thread()";
    }

    public static class QueryThreadsRequestData {
        @JsonProperty(value="filter")
        @Nullable
        private Map<String, Object> filter;
        @JsonProperty(value="sort")
        @Nullable
        private List<Sort> sorts;
        @JsonProperty(value="watch")
        @Nullable
        private Boolean watch;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;
        @JsonProperty(value="limit")
        @Nullable
        private Integer limit;
        @JsonProperty(value="next")
        @Nullable
        private String next;
        @JsonProperty(value="prev")
        @Nullable
        private String prev;

        QueryThreadsRequestData(@Nullable Map<String, Object> filter, @Nullable List<Sort> sorts, @Nullable Boolean watch, @Nullable String userId, @Nullable User.UserRequestObject user, @Nullable Integer limit, @Nullable String next, @Nullable String prev) {
            this.filter = filter;
            this.sorts = sorts;
            this.watch = watch;
            this.userId = userId;
            this.user = user;
            this.limit = limit;
            this.next = next;
            this.prev = prev;
        }

        public static class QueryThreadsRequest
        extends StreamRequest<QueryThreadsResponse> {
            private Map<String, Object> filter;
            private ArrayList<Sort> sorts;
            private Boolean watch;
            private String userId;
            private User.UserRequestObject user;
            private Integer limit;
            private String next;
            private String prev;

            @Override
            protected Call<QueryThreadsResponse> generateCall(Client client) throws StreamException {
                return client.create(ThreadService.class).queryThreads(this.internalBuild());
            }

            @JsonProperty(value="filter")
            public QueryThreadsRequest filter(@Nullable Map<String, Object> filter) {
                this.filter = filter;
                return this;
            }

            public QueryThreadsRequest sort(Sort sort) {
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.add(sort);
                return this;
            }

            @JsonProperty(value="sort")
            public QueryThreadsRequest sorts(Collection<? extends Sort> sorts) {
                if (sorts == null) {
                    throw new NullPointerException("sorts cannot be null");
                }
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.addAll(sorts);
                return this;
            }

            public QueryThreadsRequest clearSorts() {
                if (this.sorts != null) {
                    this.sorts.clear();
                }
                return this;
            }

            @JsonProperty(value="watch")
            public QueryThreadsRequest watch(@Nullable Boolean watch) {
                this.watch = watch;
                return this;
            }

            @JsonProperty(value="user_id")
            public QueryThreadsRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public QueryThreadsRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            @JsonProperty(value="limit")
            public QueryThreadsRequest limit(@Nullable Integer limit) {
                this.limit = limit;
                return this;
            }

            @JsonProperty(value="next")
            public QueryThreadsRequest next(@Nullable String next) {
                this.next = next;
                return this;
            }

            @JsonProperty(value="prev")
            public QueryThreadsRequest prev(@Nullable String prev) {
                this.prev = prev;
                return this;
            }

            public QueryThreadsRequestData internalBuild() {
                List<Sort> sorts;
                switch (this.sorts == null ? 0 : this.sorts.size()) {
                    case 0: {
                        sorts = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        sorts = Collections.singletonList(this.sorts.get(0));
                        break;
                    }
                    default: {
                        sorts = Collections.unmodifiableList(new ArrayList<Sort>(this.sorts));
                    }
                }
                return new QueryThreadsRequestData(this.filter, sorts, this.watch, this.userId, this.user, this.limit, this.next, this.prev);
            }

            public String toString() {
                return "Thread.QueryThreadsRequestData.QueryThreadsRequest(filter=" + String.valueOf(this.filter) + ", sorts=" + String.valueOf(this.sorts) + ", watch=" + this.watch + ", userId=" + this.userId + ", user=" + String.valueOf(this.user) + ", limit=" + this.limit + ", next=" + this.next + ", prev=" + this.prev + ")";
            }
        }
    }

    public static class QueryThreadsResponse
    extends StreamResponseObject {
        @JsonProperty(value="threads")
        @NotNull
        private List<ThreadObject> threads;
        @JsonProperty(value="next")
        @Nullable
        private String next;
        @JsonProperty(value="prev")
        @Nullable
        private String prev;

        @NotNull
        public List<ThreadObject> getThreads() {
            return this.threads;
        }

        @Nullable
        public String getNext() {
            return this.next;
        }

        @Nullable
        public String getPrev() {
            return this.prev;
        }

        @JsonProperty(value="threads")
        public void setThreads(@NotNull List<ThreadObject> threads) {
            if (threads == null) {
                throw new NullPointerException("threads is marked non-null but is null");
            }
            this.threads = threads;
        }

        @JsonProperty(value="next")
        public void setNext(@Nullable String next) {
            this.next = next;
        }

        @JsonProperty(value="prev")
        public void setPrev(@Nullable String prev) {
            this.prev = prev;
        }

        @Override
        public String toString() {
            return "Thread.QueryThreadsResponse(threads=" + String.valueOf(this.getThreads()) + ", next=" + this.getNext() + ", prev=" + this.getPrev() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueryThreadsResponse)) {
                return false;
            }
            QueryThreadsResponse other = (QueryThreadsResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<ThreadObject> this$threads = this.getThreads();
            List<ThreadObject> other$threads = other.getThreads();
            if (this$threads == null ? other$threads != null : !((Object)this$threads).equals(other$threads)) {
                return false;
            }
            String this$next = this.getNext();
            String other$next = other.getNext();
            if (this$next == null ? other$next != null : !this$next.equals(other$next)) {
                return false;
            }
            String this$prev = this.getPrev();
            String other$prev = other.getPrev();
            return !(this$prev == null ? other$prev != null : !this$prev.equals(other$prev));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof QueryThreadsResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<ThreadObject> $threads = this.getThreads();
            result = result * 59 + ($threads == null ? 43 : ((Object)$threads).hashCode());
            String $next = this.getNext();
            result = result * 59 + ($next == null ? 43 : $next.hashCode());
            String $prev = this.getPrev();
            result = result * 59 + ($prev == null ? 43 : $prev.hashCode());
            return result;
        }
    }

    public static class ThreadObject {
        @JsonProperty(value="app_pk")
        @Nullable
        private Integer appPk;
        @JsonProperty(value="channel_cid")
        @NotNull
        private String channelCid;
        @JsonProperty(value="channel")
        @Nullable
        private Channel channel;
        @JsonProperty(value="parent_message_id")
        @NotNull
        private String parentMessageId;
        @JsonProperty(value="parent_message")
        @Nullable
        private Message parentMessage;
        @JsonProperty(value="created_by_user_id")
        @NotNull
        private String createdByUserId;
        @JsonProperty(value="created_by")
        @Nullable
        private User createdBy;
        @JsonProperty(value="reply_count")
        @Nullable
        private Integer replyCount;
        @JsonProperty(value="participant_count")
        @Nullable
        private Integer participantCount;
        @JsonProperty(value="active_participant_count")
        @Nullable
        private Integer activeParticipantCount;
        @JsonProperty(value="thread_participants")
        @Nullable
        private List<ThreadParticipant> participants;
        @JsonProperty(value="last_message_at")
        @Nullable
        private Date lastMessageAt;
        @JsonProperty(value="created_at")
        @NotNull
        private Date createdAt;
        @JsonProperty(value="updated_at")
        @NotNull
        private Date updatedAt;
        @JsonProperty(value="deleted_at")
        @Nullable
        private Date deletedAt;
        @JsonProperty(value="title")
        @NotNull
        private String title;
        @JsonProperty(value="custom")
        @Nullable
        private Map<String, Object> custom;
        @JsonProperty(value="latest_replies")
        @Nullable
        private List<Message> latestReplies;
        @JsonProperty(value="read")
        @Nullable
        private List<Channel.ChannelRead> read;
        @JsonProperty(value="draft")
        @Nullable
        private Draft.DraftObject draft;

        @Nullable
        public Integer getAppPk() {
            return this.appPk;
        }

        @NotNull
        public String getChannelCid() {
            return this.channelCid;
        }

        @Nullable
        public Channel getChannel() {
            return this.channel;
        }

        @NotNull
        public String getParentMessageId() {
            return this.parentMessageId;
        }

        @Nullable
        public Message getParentMessage() {
            return this.parentMessage;
        }

        @NotNull
        public String getCreatedByUserId() {
            return this.createdByUserId;
        }

        @Nullable
        public User getCreatedBy() {
            return this.createdBy;
        }

        @Nullable
        public Integer getReplyCount() {
            return this.replyCount;
        }

        @Nullable
        public Integer getParticipantCount() {
            return this.participantCount;
        }

        @Nullable
        public Integer getActiveParticipantCount() {
            return this.activeParticipantCount;
        }

        @Nullable
        public List<ThreadParticipant> getParticipants() {
            return this.participants;
        }

        @Nullable
        public Date getLastMessageAt() {
            return this.lastMessageAt;
        }

        @NotNull
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @NotNull
        public Date getUpdatedAt() {
            return this.updatedAt;
        }

        @Nullable
        public Date getDeletedAt() {
            return this.deletedAt;
        }

        @NotNull
        public String getTitle() {
            return this.title;
        }

        @Nullable
        public Map<String, Object> getCustom() {
            return this.custom;
        }

        @Nullable
        public List<Message> getLatestReplies() {
            return this.latestReplies;
        }

        @Nullable
        public List<Channel.ChannelRead> getRead() {
            return this.read;
        }

        @Nullable
        public Draft.DraftObject getDraft() {
            return this.draft;
        }

        @JsonProperty(value="app_pk")
        public void setAppPk(@Nullable Integer appPk) {
            this.appPk = appPk;
        }

        @JsonProperty(value="channel_cid")
        public void setChannelCid(@NotNull String channelCid) {
            if (channelCid == null) {
                throw new NullPointerException("channelCid is marked non-null but is null");
            }
            this.channelCid = channelCid;
        }

        @JsonProperty(value="channel")
        public void setChannel(@Nullable Channel channel) {
            this.channel = channel;
        }

        @JsonProperty(value="parent_message_id")
        public void setParentMessageId(@NotNull String parentMessageId) {
            if (parentMessageId == null) {
                throw new NullPointerException("parentMessageId is marked non-null but is null");
            }
            this.parentMessageId = parentMessageId;
        }

        @JsonProperty(value="parent_message")
        public void setParentMessage(@Nullable Message parentMessage) {
            this.parentMessage = parentMessage;
        }

        @JsonProperty(value="created_by_user_id")
        public void setCreatedByUserId(@NotNull String createdByUserId) {
            if (createdByUserId == null) {
                throw new NullPointerException("createdByUserId is marked non-null but is null");
            }
            this.createdByUserId = createdByUserId;
        }

        @JsonProperty(value="created_by")
        public void setCreatedBy(@Nullable User createdBy) {
            this.createdBy = createdBy;
        }

        @JsonProperty(value="reply_count")
        public void setReplyCount(@Nullable Integer replyCount) {
            this.replyCount = replyCount;
        }

        @JsonProperty(value="participant_count")
        public void setParticipantCount(@Nullable Integer participantCount) {
            this.participantCount = participantCount;
        }

        @JsonProperty(value="active_participant_count")
        public void setActiveParticipantCount(@Nullable Integer activeParticipantCount) {
            this.activeParticipantCount = activeParticipantCount;
        }

        @JsonProperty(value="thread_participants")
        public void setParticipants(@Nullable List<ThreadParticipant> participants) {
            this.participants = participants;
        }

        @JsonProperty(value="last_message_at")
        public void setLastMessageAt(@Nullable Date lastMessageAt) {
            this.lastMessageAt = lastMessageAt;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@NotNull Date createdAt) {
            if (createdAt == null) {
                throw new NullPointerException("createdAt is marked non-null but is null");
            }
            this.createdAt = createdAt;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@NotNull Date updatedAt) {
            if (updatedAt == null) {
                throw new NullPointerException("updatedAt is marked non-null but is null");
            }
            this.updatedAt = updatedAt;
        }

        @JsonProperty(value="deleted_at")
        public void setDeletedAt(@Nullable Date deletedAt) {
            this.deletedAt = deletedAt;
        }

        @JsonProperty(value="title")
        public void setTitle(@NotNull String title) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            this.title = title;
        }

        @JsonProperty(value="custom")
        public void setCustom(@Nullable Map<String, Object> custom) {
            this.custom = custom;
        }

        @JsonProperty(value="latest_replies")
        public void setLatestReplies(@Nullable List<Message> latestReplies) {
            this.latestReplies = latestReplies;
        }

        @JsonProperty(value="read")
        public void setRead(@Nullable List<Channel.ChannelRead> read) {
            this.read = read;
        }

        @JsonProperty(value="draft")
        public void setDraft(@Nullable Draft.DraftObject draft) {
            this.draft = draft;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThreadObject)) {
                return false;
            }
            ThreadObject other = (ThreadObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$appPk = this.getAppPk();
            Integer other$appPk = other.getAppPk();
            if (this$appPk == null ? other$appPk != null : !((Object)this$appPk).equals(other$appPk)) {
                return false;
            }
            Integer this$replyCount = this.getReplyCount();
            Integer other$replyCount = other.getReplyCount();
            if (this$replyCount == null ? other$replyCount != null : !((Object)this$replyCount).equals(other$replyCount)) {
                return false;
            }
            Integer this$participantCount = this.getParticipantCount();
            Integer other$participantCount = other.getParticipantCount();
            if (this$participantCount == null ? other$participantCount != null : !((Object)this$participantCount).equals(other$participantCount)) {
                return false;
            }
            Integer this$activeParticipantCount = this.getActiveParticipantCount();
            Integer other$activeParticipantCount = other.getActiveParticipantCount();
            if (this$activeParticipantCount == null ? other$activeParticipantCount != null : !((Object)this$activeParticipantCount).equals(other$activeParticipantCount)) {
                return false;
            }
            String this$channelCid = this.getChannelCid();
            String other$channelCid = other.getChannelCid();
            if (this$channelCid == null ? other$channelCid != null : !this$channelCid.equals(other$channelCid)) {
                return false;
            }
            Channel this$channel = this.getChannel();
            Channel other$channel = other.getChannel();
            if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
                return false;
            }
            String this$parentMessageId = this.getParentMessageId();
            String other$parentMessageId = other.getParentMessageId();
            if (this$parentMessageId == null ? other$parentMessageId != null : !this$parentMessageId.equals(other$parentMessageId)) {
                return false;
            }
            Message this$parentMessage = this.getParentMessage();
            Message other$parentMessage = other.getParentMessage();
            if (this$parentMessage == null ? other$parentMessage != null : !((Object)this$parentMessage).equals(other$parentMessage)) {
                return false;
            }
            String this$createdByUserId = this.getCreatedByUserId();
            String other$createdByUserId = other.getCreatedByUserId();
            if (this$createdByUserId == null ? other$createdByUserId != null : !this$createdByUserId.equals(other$createdByUserId)) {
                return false;
            }
            User this$createdBy = this.getCreatedBy();
            User other$createdBy = other.getCreatedBy();
            if (this$createdBy == null ? other$createdBy != null : !((Object)this$createdBy).equals(other$createdBy)) {
                return false;
            }
            List<ThreadParticipant> this$participants = this.getParticipants();
            List<ThreadParticipant> other$participants = other.getParticipants();
            if (this$participants == null ? other$participants != null : !((Object)this$participants).equals(other$participants)) {
                return false;
            }
            Date this$lastMessageAt = this.getLastMessageAt();
            Date other$lastMessageAt = other.getLastMessageAt();
            if (this$lastMessageAt == null ? other$lastMessageAt != null : !((Object)this$lastMessageAt).equals(other$lastMessageAt)) {
                return false;
            }
            Date this$createdAt = this.getCreatedAt();
            Date other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
                return false;
            }
            Date this$updatedAt = this.getUpdatedAt();
            Date other$updatedAt = other.getUpdatedAt();
            if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
                return false;
            }
            Date this$deletedAt = this.getDeletedAt();
            Date other$deletedAt = other.getDeletedAt();
            if (this$deletedAt == null ? other$deletedAt != null : !((Object)this$deletedAt).equals(other$deletedAt)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            Map<String, Object> this$custom = this.getCustom();
            Map<String, Object> other$custom = other.getCustom();
            if (this$custom == null ? other$custom != null : !((Object)this$custom).equals(other$custom)) {
                return false;
            }
            List<Message> this$latestReplies = this.getLatestReplies();
            List<Message> other$latestReplies = other.getLatestReplies();
            if (this$latestReplies == null ? other$latestReplies != null : !((Object)this$latestReplies).equals(other$latestReplies)) {
                return false;
            }
            List<Channel.ChannelRead> this$read = this.getRead();
            List<Channel.ChannelRead> other$read = other.getRead();
            if (this$read == null ? other$read != null : !((Object)this$read).equals(other$read)) {
                return false;
            }
            Draft.DraftObject this$draft = this.getDraft();
            Draft.DraftObject other$draft = other.getDraft();
            return !(this$draft == null ? other$draft != null : !((Object)this$draft).equals(other$draft));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ThreadObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $appPk = this.getAppPk();
            result = result * 59 + ($appPk == null ? 43 : ((Object)$appPk).hashCode());
            Integer $replyCount = this.getReplyCount();
            result = result * 59 + ($replyCount == null ? 43 : ((Object)$replyCount).hashCode());
            Integer $participantCount = this.getParticipantCount();
            result = result * 59 + ($participantCount == null ? 43 : ((Object)$participantCount).hashCode());
            Integer $activeParticipantCount = this.getActiveParticipantCount();
            result = result * 59 + ($activeParticipantCount == null ? 43 : ((Object)$activeParticipantCount).hashCode());
            String $channelCid = this.getChannelCid();
            result = result * 59 + ($channelCid == null ? 43 : $channelCid.hashCode());
            Channel $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
            String $parentMessageId = this.getParentMessageId();
            result = result * 59 + ($parentMessageId == null ? 43 : $parentMessageId.hashCode());
            Message $parentMessage = this.getParentMessage();
            result = result * 59 + ($parentMessage == null ? 43 : ((Object)$parentMessage).hashCode());
            String $createdByUserId = this.getCreatedByUserId();
            result = result * 59 + ($createdByUserId == null ? 43 : $createdByUserId.hashCode());
            User $createdBy = this.getCreatedBy();
            result = result * 59 + ($createdBy == null ? 43 : ((Object)$createdBy).hashCode());
            List<ThreadParticipant> $participants = this.getParticipants();
            result = result * 59 + ($participants == null ? 43 : ((Object)$participants).hashCode());
            Date $lastMessageAt = this.getLastMessageAt();
            result = result * 59 + ($lastMessageAt == null ? 43 : ((Object)$lastMessageAt).hashCode());
            Date $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            Date $updatedAt = this.getUpdatedAt();
            result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
            Date $deletedAt = this.getDeletedAt();
            result = result * 59 + ($deletedAt == null ? 43 : ((Object)$deletedAt).hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            Map<String, Object> $custom = this.getCustom();
            result = result * 59 + ($custom == null ? 43 : ((Object)$custom).hashCode());
            List<Message> $latestReplies = this.getLatestReplies();
            result = result * 59 + ($latestReplies == null ? 43 : ((Object)$latestReplies).hashCode());
            List<Channel.ChannelRead> $read = this.getRead();
            result = result * 59 + ($read == null ? 43 : ((Object)$read).hashCode());
            Draft.DraftObject $draft = this.getDraft();
            result = result * 59 + ($draft == null ? 43 : ((Object)$draft).hashCode());
            return result;
        }

        public String toString() {
            return "Thread.ThreadObject(appPk=" + this.getAppPk() + ", channelCid=" + this.getChannelCid() + ", channel=" + String.valueOf(this.getChannel()) + ", parentMessageId=" + this.getParentMessageId() + ", parentMessage=" + String.valueOf(this.getParentMessage()) + ", createdByUserId=" + this.getCreatedByUserId() + ", createdBy=" + String.valueOf(this.getCreatedBy()) + ", replyCount=" + this.getReplyCount() + ", participantCount=" + this.getParticipantCount() + ", activeParticipantCount=" + this.getActiveParticipantCount() + ", participants=" + String.valueOf(this.getParticipants()) + ", lastMessageAt=" + String.valueOf(this.getLastMessageAt()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", deletedAt=" + String.valueOf(this.getDeletedAt()) + ", title=" + this.getTitle() + ", custom=" + String.valueOf(this.getCustom()) + ", latestReplies=" + String.valueOf(this.getLatestReplies()) + ", read=" + String.valueOf(this.getRead()) + ", draft=" + String.valueOf(this.getDraft()) + ")";
        }
    }

    public static class ThreadParticipant {
        @JsonProperty(value="app_pk")
        @Nullable
        private Integer appPk;
        @JsonProperty(value="channel_cid")
        @Nullable
        private String channelCid;
        @JsonProperty(value="last_thread_message_at")
        @Nullable
        private Date lastThreadMessageAt;
        @JsonProperty(value="thread_id")
        @Nullable
        private String threadId;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User user;
        @JsonProperty(value="created_at")
        @Nullable
        private Date createdAt;
        @JsonProperty(value="left_thread_at")
        @Nullable
        private Date leftThreadAt;
        @JsonProperty(value="last_read_at")
        @Nullable
        private Date lastReadAt;
        @JsonProperty(value="custom")
        @Nullable
        private Map<String, Object> custom;

        @Nullable
        public Integer getAppPk() {
            return this.appPk;
        }

        @Nullable
        public String getChannelCid() {
            return this.channelCid;
        }

        @Nullable
        public Date getLastThreadMessageAt() {
            return this.lastThreadMessageAt;
        }

        @Nullable
        public String getThreadId() {
            return this.threadId;
        }

        @Nullable
        public String getUserId() {
            return this.userId;
        }

        @Nullable
        public User getUser() {
            return this.user;
        }

        @Nullable
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @Nullable
        public Date getLeftThreadAt() {
            return this.leftThreadAt;
        }

        @Nullable
        public Date getLastReadAt() {
            return this.lastReadAt;
        }

        @Nullable
        public Map<String, Object> getCustom() {
            return this.custom;
        }

        @JsonProperty(value="app_pk")
        public void setAppPk(@Nullable Integer appPk) {
            this.appPk = appPk;
        }

        @JsonProperty(value="channel_cid")
        public void setChannelCid(@Nullable String channelCid) {
            this.channelCid = channelCid;
        }

        @JsonProperty(value="last_thread_message_at")
        public void setLastThreadMessageAt(@Nullable Date lastThreadMessageAt) {
            this.lastThreadMessageAt = lastThreadMessageAt;
        }

        @JsonProperty(value="thread_id")
        public void setThreadId(@Nullable String threadId) {
            this.threadId = threadId;
        }

        @JsonProperty(value="user_id")
        public void setUserId(@Nullable String userId) {
            this.userId = userId;
        }

        @JsonProperty(value="user")
        public void setUser(@Nullable User user) {
            this.user = user;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@Nullable Date createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="left_thread_at")
        public void setLeftThreadAt(@Nullable Date leftThreadAt) {
            this.leftThreadAt = leftThreadAt;
        }

        @JsonProperty(value="last_read_at")
        public void setLastReadAt(@Nullable Date lastReadAt) {
            this.lastReadAt = lastReadAt;
        }

        @JsonProperty(value="custom")
        public void setCustom(@Nullable Map<String, Object> custom) {
            this.custom = custom;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThreadParticipant)) {
                return false;
            }
            ThreadParticipant other = (ThreadParticipant)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$appPk = this.getAppPk();
            Integer other$appPk = other.getAppPk();
            if (this$appPk == null ? other$appPk != null : !((Object)this$appPk).equals(other$appPk)) {
                return false;
            }
            String this$channelCid = this.getChannelCid();
            String other$channelCid = other.getChannelCid();
            if (this$channelCid == null ? other$channelCid != null : !this$channelCid.equals(other$channelCid)) {
                return false;
            }
            Date this$lastThreadMessageAt = this.getLastThreadMessageAt();
            Date other$lastThreadMessageAt = other.getLastThreadMessageAt();
            if (this$lastThreadMessageAt == null ? other$lastThreadMessageAt != null : !((Object)this$lastThreadMessageAt).equals(other$lastThreadMessageAt)) {
                return false;
            }
            String this$threadId = this.getThreadId();
            String other$threadId = other.getThreadId();
            if (this$threadId == null ? other$threadId != null : !this$threadId.equals(other$threadId)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            User this$user = this.getUser();
            User other$user = other.getUser();
            if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
                return false;
            }
            Date this$createdAt = this.getCreatedAt();
            Date other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
                return false;
            }
            Date this$leftThreadAt = this.getLeftThreadAt();
            Date other$leftThreadAt = other.getLeftThreadAt();
            if (this$leftThreadAt == null ? other$leftThreadAt != null : !((Object)this$leftThreadAt).equals(other$leftThreadAt)) {
                return false;
            }
            Date this$lastReadAt = this.getLastReadAt();
            Date other$lastReadAt = other.getLastReadAt();
            if (this$lastReadAt == null ? other$lastReadAt != null : !((Object)this$lastReadAt).equals(other$lastReadAt)) {
                return false;
            }
            Map<String, Object> this$custom = this.getCustom();
            Map<String, Object> other$custom = other.getCustom();
            return !(this$custom == null ? other$custom != null : !((Object)this$custom).equals(other$custom));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ThreadParticipant;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $appPk = this.getAppPk();
            result = result * 59 + ($appPk == null ? 43 : ((Object)$appPk).hashCode());
            String $channelCid = this.getChannelCid();
            result = result * 59 + ($channelCid == null ? 43 : $channelCid.hashCode());
            Date $lastThreadMessageAt = this.getLastThreadMessageAt();
            result = result * 59 + ($lastThreadMessageAt == null ? 43 : ((Object)$lastThreadMessageAt).hashCode());
            String $threadId = this.getThreadId();
            result = result * 59 + ($threadId == null ? 43 : $threadId.hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            User $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            Date $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            Date $leftThreadAt = this.getLeftThreadAt();
            result = result * 59 + ($leftThreadAt == null ? 43 : ((Object)$leftThreadAt).hashCode());
            Date $lastReadAt = this.getLastReadAt();
            result = result * 59 + ($lastReadAt == null ? 43 : ((Object)$lastReadAt).hashCode());
            Map<String, Object> $custom = this.getCustom();
            result = result * 59 + ($custom == null ? 43 : ((Object)$custom).hashCode());
            return result;
        }

        public String toString() {
            return "Thread.ThreadParticipant(appPk=" + this.getAppPk() + ", channelCid=" + this.getChannelCid() + ", lastThreadMessageAt=" + String.valueOf(this.getLastThreadMessageAt()) + ", threadId=" + this.getThreadId() + ", userId=" + this.getUserId() + ", user=" + String.valueOf(this.getUser()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", leftThreadAt=" + String.valueOf(this.getLeftThreadAt()) + ", lastReadAt=" + String.valueOf(this.getLastReadAt()) + ", custom=" + String.valueOf(this.getCustom()) + ")";
        }
    }
}

