/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.getstream.chat.java.models.Message;
import io.getstream.chat.java.models.User;
import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.ReminderService;
import io.getstream.chat.java.services.framework.Client;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;

public class Reminder {
    @JsonProperty(value="id")
    @NotNull
    private String id;
    @JsonProperty(value="message_id")
    @NotNull
    private String messageId;
    @JsonProperty(value="message")
    @Nullable
    private Message message;
    @JsonProperty(value="user_id")
    @NotNull
    private String userId;
    @JsonProperty(value="user")
    @Nullable
    private User user;
    @JsonProperty(value="channel_cid")
    @NotNull
    private String channelCid;
    @JsonProperty(value="remind_at")
    @Nullable
    private Date remindAt;
    @JsonProperty(value="created_at")
    @Nullable
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @Nullable
    private Date updatedAt;
    @JsonIgnore
    @NotNull
    private Map<String, Object> additionalFields = new HashMap<String, Object>();

    @JsonAnyGetter
    public Map<String, Object> getAdditionalFields() {
        return this.additionalFields;
    }

    @JsonAnySetter
    public void setAdditionalField(String name, Object value) {
        this.additionalFields.put(name, value);
    }

    @NotNull
    public static ReminderCreateRequestData.ReminderCreateRequest createReminder(@NotNull String messageId) {
        return new ReminderCreateRequestData.ReminderCreateRequest(messageId);
    }

    @NotNull
    public static ReminderUpdateRequestData.ReminderUpdateRequest updateReminder(@NotNull String messageId) {
        return new ReminderUpdateRequestData.ReminderUpdateRequest(messageId);
    }

    @NotNull
    public static ReminderDeleteRequest deleteReminder(@NotNull String messageId, @NotNull String userId) {
        return new ReminderDeleteRequest(messageId, userId);
    }

    @NotNull
    public static ReminderQueryRequestData.ReminderQueryRequest queryReminders() {
        return new ReminderQueryRequestData.ReminderQueryRequest();
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public String getMessageId() {
        return this.messageId;
    }

    @Nullable
    public Message getMessage() {
        return this.message;
    }

    @NotNull
    public String getUserId() {
        return this.userId;
    }

    @Nullable
    public User getUser() {
        return this.user;
    }

    @NotNull
    public String getChannelCid() {
        return this.channelCid;
    }

    @Nullable
    public Date getRemindAt() {
        return this.remindAt;
    }

    @Nullable
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="id")
    public void setId(@NotNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="message_id")
    public void setMessageId(@NotNull String messageId) {
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.messageId = messageId;
    }

    @JsonProperty(value="message")
    public void setMessage(@Nullable Message message) {
        this.message = message;
    }

    @JsonProperty(value="user_id")
    public void setUserId(@NotNull String userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @JsonProperty(value="user")
    public void setUser(@Nullable User user) {
        this.user = user;
    }

    @JsonProperty(value="channel_cid")
    public void setChannelCid(@NotNull String channelCid) {
        if (channelCid == null) {
            throw new NullPointerException("channelCid is marked non-null but is null");
        }
        this.channelCid = channelCid;
    }

    @JsonProperty(value="remind_at")
    public void setRemindAt(@Nullable Date remindAt) {
        this.remindAt = remindAt;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(@Nullable Date createdAt) {
        this.createdAt = createdAt;
    }

    @JsonProperty(value="updated_at")
    public void setUpdatedAt(@Nullable Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @JsonIgnore
    public void setAdditionalFields(@NotNull Map<String, Object> additionalFields) {
        if (additionalFields == null) {
            throw new NullPointerException("additionalFields is marked non-null but is null");
        }
        this.additionalFields = additionalFields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Reminder)) {
            return false;
        }
        Reminder other = (Reminder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        Message this$message = this.getMessage();
        Message other$message = other.getMessage();
        if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        String this$channelCid = this.getChannelCid();
        String other$channelCid = other.getChannelCid();
        if (this$channelCid == null ? other$channelCid != null : !this$channelCid.equals(other$channelCid)) {
            return false;
        }
        Date this$remindAt = this.getRemindAt();
        Date other$remindAt = other.getRemindAt();
        if (this$remindAt == null ? other$remindAt != null : !((Object)this$remindAt).equals(other$remindAt)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Date this$updatedAt = this.getUpdatedAt();
        Date other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        Map<String, Object> this$additionalFields = this.getAdditionalFields();
        Map<String, Object> other$additionalFields = other.getAdditionalFields();
        return !(this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Reminder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        Message $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        String $channelCid = this.getChannelCid();
        result = result * 59 + ($channelCid == null ? 43 : $channelCid.hashCode());
        Date $remindAt = this.getRemindAt();
        result = result * 59 + ($remindAt == null ? 43 : ((Object)$remindAt).hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Date $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        Map<String, Object> $additionalFields = this.getAdditionalFields();
        result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
        return result;
    }

    public String toString() {
        return "Reminder(id=" + this.getId() + ", messageId=" + this.getMessageId() + ", message=" + String.valueOf(this.getMessage()) + ", userId=" + this.getUserId() + ", user=" + String.valueOf(this.getUser()) + ", channelCid=" + this.getChannelCid() + ", remindAt=" + String.valueOf(this.getRemindAt()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", additionalFields=" + String.valueOf(this.getAdditionalFields()) + ")";
    }

    public static class ReminderQueryResponse
    extends StreamResponseObject {
        @JsonProperty(value="reminders")
        @NotNull
        private List<Reminder> reminders;
        @JsonProperty(value="prev")
        @Nullable
        private String prev;
        @JsonProperty(value="next")
        @Nullable
        private String next;

        @NotNull
        public List<Reminder> getReminders() {
            return this.reminders;
        }

        @Nullable
        public String getPrev() {
            return this.prev;
        }

        @Nullable
        public String getNext() {
            return this.next;
        }

        @JsonProperty(value="reminders")
        public void setReminders(@NotNull List<Reminder> reminders) {
            if (reminders == null) {
                throw new NullPointerException("reminders is marked non-null but is null");
            }
            this.reminders = reminders;
        }

        @JsonProperty(value="prev")
        public void setPrev(@Nullable String prev) {
            this.prev = prev;
        }

        @JsonProperty(value="next")
        public void setNext(@Nullable String next) {
            this.next = next;
        }

        @Override
        public String toString() {
            return "Reminder.ReminderQueryResponse(reminders=" + String.valueOf(this.getReminders()) + ", prev=" + this.getPrev() + ", next=" + this.getNext() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReminderQueryResponse)) {
                return false;
            }
            ReminderQueryResponse other = (ReminderQueryResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<Reminder> this$reminders = this.getReminders();
            List<Reminder> other$reminders = other.getReminders();
            if (this$reminders == null ? other$reminders != null : !((Object)this$reminders).equals(other$reminders)) {
                return false;
            }
            String this$prev = this.getPrev();
            String other$prev = other.getPrev();
            if (this$prev == null ? other$prev != null : !this$prev.equals(other$prev)) {
                return false;
            }
            String this$next = this.getNext();
            String other$next = other.getNext();
            return !(this$next == null ? other$next != null : !this$next.equals(other$next));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ReminderQueryResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<Reminder> $reminders = this.getReminders();
            result = result * 59 + ($reminders == null ? 43 : ((Object)$reminders).hashCode());
            String $prev = this.getPrev();
            result = result * 59 + ($prev == null ? 43 : $prev.hashCode());
            String $next = this.getNext();
            result = result * 59 + ($next == null ? 43 : $next.hashCode());
            return result;
        }
    }

    public static class ReminderDeleteResponse
    extends StreamResponseObject {
        @JsonProperty(value="reminder")
        @NotNull
        private Reminder reminder;

        @NotNull
        public Reminder getReminder() {
            return this.reminder;
        }

        @JsonProperty(value="reminder")
        public void setReminder(@NotNull Reminder reminder) {
            if (reminder == null) {
                throw new NullPointerException("reminder is marked non-null but is null");
            }
            this.reminder = reminder;
        }

        @Override
        public String toString() {
            return "Reminder.ReminderDeleteResponse(reminder=" + String.valueOf(this.getReminder()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReminderDeleteResponse)) {
                return false;
            }
            ReminderDeleteResponse other = (ReminderDeleteResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Reminder this$reminder = this.getReminder();
            Reminder other$reminder = other.getReminder();
            return !(this$reminder == null ? other$reminder != null : !((Object)this$reminder).equals(other$reminder));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ReminderDeleteResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Reminder $reminder = this.getReminder();
            result = result * 59 + ($reminder == null ? 43 : ((Object)$reminder).hashCode());
            return result;
        }
    }

    public static class ReminderUpdateResponse
    extends StreamResponseObject {
        @JsonProperty(value="reminder")
        @NotNull
        private Reminder reminder;

        @NotNull
        public Reminder getReminder() {
            return this.reminder;
        }

        @JsonProperty(value="reminder")
        public void setReminder(@NotNull Reminder reminder) {
            if (reminder == null) {
                throw new NullPointerException("reminder is marked non-null but is null");
            }
            this.reminder = reminder;
        }

        @Override
        public String toString() {
            return "Reminder.ReminderUpdateResponse(reminder=" + String.valueOf(this.getReminder()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReminderUpdateResponse)) {
                return false;
            }
            ReminderUpdateResponse other = (ReminderUpdateResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Reminder this$reminder = this.getReminder();
            Reminder other$reminder = other.getReminder();
            return !(this$reminder == null ? other$reminder != null : !((Object)this$reminder).equals(other$reminder));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ReminderUpdateResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Reminder $reminder = this.getReminder();
            result = result * 59 + ($reminder == null ? 43 : ((Object)$reminder).hashCode());
            return result;
        }
    }

    public static class ReminderCreateResponse
    extends StreamResponseObject {
        @JsonProperty(value="reminder")
        @NotNull
        private Reminder reminder;

        @NotNull
        public Reminder getReminder() {
            return this.reminder;
        }

        @JsonProperty(value="reminder")
        public void setReminder(@NotNull Reminder reminder) {
            if (reminder == null) {
                throw new NullPointerException("reminder is marked non-null but is null");
            }
            this.reminder = reminder;
        }

        @Override
        public String toString() {
            return "Reminder.ReminderCreateResponse(reminder=" + String.valueOf(this.getReminder()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReminderCreateResponse)) {
                return false;
            }
            ReminderCreateResponse other = (ReminderCreateResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Reminder this$reminder = this.getReminder();
            Reminder other$reminder = other.getReminder();
            return !(this$reminder == null ? other$reminder != null : !((Object)this$reminder).equals(other$reminder));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ReminderCreateResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Reminder $reminder = this.getReminder();
            result = result * 59 + ($reminder == null ? 43 : ((Object)$reminder).hashCode());
            return result;
        }
    }

    public static class ReminderQueryRequestData {
        @JsonProperty(value="user_id")
        @NotNull
        private String userId;
        @JsonProperty(value="filter_conditions")
        @Nullable
        private Map<String, Object> filterConditions;
        @JsonProperty(value="sort")
        @Nullable
        private List<Map<String, Object>> sorts;
        @JsonProperty(value="limit")
        @Nullable
        private Integer limit;
        @JsonProperty(value="offset")
        @Nullable
        private Integer offset;

        ReminderQueryRequestData(@NotNull String userId, @Nullable Map<String, Object> filterConditions, @Nullable List<Map<String, Object>> sorts, @Nullable Integer limit, @Nullable Integer offset) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            this.filterConditions = filterConditions;
            this.sorts = sorts;
            this.limit = limit;
            this.offset = offset;
        }

        public static class ReminderQueryRequest
        extends StreamRequest<ReminderQueryResponse> {
            private String userId;
            private ArrayList<String> filterConditions$key;
            private ArrayList<Object> filterConditions$value;
            private ArrayList<Map<String, Object>> sorts;
            private Integer limit;
            private Integer offset;

            @Override
            protected Call<ReminderQueryResponse> generateCall(Client client) {
                return client.create(ReminderService.class).query(this.internalBuild());
            }

            ReminderQueryRequest() {
            }

            @JsonProperty(value="user_id")
            public ReminderQueryRequest userId(@NotNull String userId) {
                if (userId == null) {
                    throw new NullPointerException("userId is marked non-null but is null");
                }
                this.userId = userId;
                return this;
            }

            public ReminderQueryRequest filterCondition(String filterConditionKey, Object filterConditionValue) {
                if (this.filterConditions$key == null) {
                    this.filterConditions$key = new ArrayList();
                    this.filterConditions$value = new ArrayList();
                }
                this.filterConditions$key.add(filterConditionKey);
                this.filterConditions$value.add(filterConditionValue);
                return this;
            }

            @JsonProperty(value="filter_conditions")
            public ReminderQueryRequest filterConditions(Map<? extends String, ? extends Object> filterConditions) {
                if (filterConditions == null) {
                    throw new NullPointerException("filterConditions cannot be null");
                }
                if (this.filterConditions$key == null) {
                    this.filterConditions$key = new ArrayList();
                    this.filterConditions$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : filterConditions.entrySet()) {
                    this.filterConditions$key.add($lombokEntry.getKey());
                    this.filterConditions$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public ReminderQueryRequest clearFilterConditions() {
                if (this.filterConditions$key != null) {
                    this.filterConditions$key.clear();
                    this.filterConditions$value.clear();
                }
                return this;
            }

            public ReminderQueryRequest sort(Map<String, Object> sort) {
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.add(sort);
                return this;
            }

            @JsonProperty(value="sort")
            public ReminderQueryRequest sorts(Collection<? extends Map<String, Object>> sorts) {
                if (sorts == null) {
                    throw new NullPointerException("sorts cannot be null");
                }
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.addAll(sorts);
                return this;
            }

            public ReminderQueryRequest clearSorts() {
                if (this.sorts != null) {
                    this.sorts.clear();
                }
                return this;
            }

            @JsonProperty(value="limit")
            public ReminderQueryRequest limit(@Nullable Integer limit) {
                this.limit = limit;
                return this;
            }

            @JsonProperty(value="offset")
            public ReminderQueryRequest offset(@Nullable Integer offset) {
                this.offset = offset;
                return this;
            }

            public ReminderQueryRequestData internalBuild() {
                List<Map<String, Object>> sorts;
                Map<String, Object> filterConditions;
                switch (this.filterConditions$key == null ? 0 : this.filterConditions$key.size()) {
                    case 0: {
                        filterConditions = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        filterConditions = Collections.singletonMap(this.filterConditions$key.get(0), this.filterConditions$value.get(0));
                        break;
                    }
                    default: {
                        filterConditions = new LinkedHashMap(this.filterConditions$key.size() < 0x40000000 ? 1 + this.filterConditions$key.size() + (this.filterConditions$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.filterConditions$key.size(); ++$i) {
                            filterConditions.put(this.filterConditions$key.get($i), this.filterConditions$value.get($i));
                        }
                        filterConditions = Collections.unmodifiableMap(filterConditions);
                    }
                }
                switch (this.sorts == null ? 0 : this.sorts.size()) {
                    case 0: {
                        sorts = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        sorts = Collections.singletonList(this.sorts.get(0));
                        break;
                    }
                    default: {
                        sorts = Collections.unmodifiableList(new ArrayList<Map<String, Object>>(this.sorts));
                    }
                }
                return new ReminderQueryRequestData(this.userId, filterConditions, sorts, this.limit, this.offset);
            }

            public String toString() {
                return "Reminder.ReminderQueryRequestData.ReminderQueryRequest(userId=" + this.userId + ", filterConditions$key=" + String.valueOf(this.filterConditions$key) + ", filterConditions$value=" + String.valueOf(this.filterConditions$value) + ", sorts=" + String.valueOf(this.sorts) + ", limit=" + this.limit + ", offset=" + this.offset + ")";
            }
        }
    }

    public static class ReminderDeleteRequest
    extends StreamRequest<ReminderDeleteResponse> {
        @NotNull
        private String messageId;
        @NotNull
        private String userId;

        @Override
        protected Call<ReminderDeleteResponse> generateCall(Client client) {
            return client.create(ReminderService.class).delete(this.messageId, this.userId);
        }

        public ReminderDeleteRequest(@NotNull String messageId, @NotNull String userId) {
            if (messageId == null) {
                throw new NullPointerException("messageId is marked non-null but is null");
            }
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.messageId = messageId;
            this.userId = userId;
        }
    }

    public static class ReminderUpdateRequestData {
        @JsonProperty(value="user_id")
        @NotNull
        private String userId;
        @JsonProperty(value="remind_at")
        @Nullable
        private Date remindAt;

        ReminderUpdateRequestData(@NotNull String userId, @Nullable Date remindAt) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            this.remindAt = remindAt;
        }

        public static class ReminderUpdateRequest
        extends StreamRequest<ReminderUpdateResponse> {
            private String userId;
            private Date remindAt;
            @NotNull
            private String messageId;

            private ReminderUpdateRequest(@NotNull String messageId) {
                this.messageId = messageId;
            }

            @Override
            protected Call<ReminderUpdateResponse> generateCall(Client client) {
                return client.create(ReminderService.class).update(this.messageId, this.internalBuild());
            }

            @JsonProperty(value="user_id")
            public ReminderUpdateRequest userId(@NotNull String userId) {
                if (userId == null) {
                    throw new NullPointerException("userId is marked non-null but is null");
                }
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="remind_at")
            public ReminderUpdateRequest remindAt(@Nullable Date remindAt) {
                this.remindAt = remindAt;
                return this;
            }

            public ReminderUpdateRequestData internalBuild() {
                return new ReminderUpdateRequestData(this.userId, this.remindAt);
            }

            public String toString() {
                return "Reminder.ReminderUpdateRequestData.ReminderUpdateRequest(userId=" + this.userId + ", remindAt=" + String.valueOf(this.remindAt) + ")";
            }
        }
    }

    public static class ReminderCreateRequestData {
        @JsonProperty(value="user_id")
        @NotNull
        private String userId;
        @JsonProperty(value="remind_at")
        @Nullable
        private Date remindAt;

        ReminderCreateRequestData(@NotNull String userId, @Nullable Date remindAt) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            this.remindAt = remindAt;
        }

        public static class ReminderCreateRequest
        extends StreamRequest<ReminderCreateResponse> {
            private String userId;
            private Date remindAt;
            @NotNull
            private String messageId;

            private ReminderCreateRequest(@NotNull String messageId) {
                this.messageId = messageId;
            }

            @Override
            protected Call<ReminderCreateResponse> generateCall(Client client) {
                return client.create(ReminderService.class).create(this.messageId, this.internalBuild());
            }

            @JsonProperty(value="user_id")
            public ReminderCreateRequest userId(@NotNull String userId) {
                if (userId == null) {
                    throw new NullPointerException("userId is marked non-null but is null");
                }
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="remind_at")
            public ReminderCreateRequest remindAt(@Nullable Date remindAt) {
                this.remindAt = remindAt;
                return this;
            }

            public ReminderCreateRequestData internalBuild() {
                return new ReminderCreateRequestData(this.userId, this.remindAt);
            }

            public String toString() {
                return "Reminder.ReminderCreateRequestData.ReminderCreateRequest(userId=" + this.userId + ", remindAt=" + String.valueOf(this.remindAt) + ")";
            }
        }
    }
}

