/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models.framework;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class RequestObjectBuilder {
    private static final Logger log = Logger.getLogger(RequestObjectBuilder.class.getName());

    public static <T, U> U build(Class<? extends U> requestObjectClass, T modelObject) {
        Object resultBuilder;
        if (modelObject == null) {
            return null;
        }
        log.fine("Building instance of " + requestObjectClass.getName());
        try {
            resultBuilder = requestObjectClass.getMethod("builder", new Class[0]).invoke(requestObjectClass, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("Could not find builder method in the request object class " + requestObjectClass.getName(), e);
        }
        Class<?> resultBuilderClass = resultBuilder.getClass();
        for (Field field : RequestObjectBuilder.getAllFields(modelObject.getClass())) {
            log.fine(field.getName() + " - Start treatment");
            field.setAccessible(true);
            Class<?> fieldClass = field.getType();
            Method resultBuilderMethod = RequestObjectBuilder.findBuilderMethod(resultBuilderClass, field.getName());
            if (resultBuilderMethod != null) {
                Class<?> methodParameterClass = resultBuilderMethod.getParameters()[0].getType();
                log.fine(field.getName() + " - methodParameterClass=" + methodParameterClass.getName() + " and fieldClass=" + fieldClass.getName());
                if (Collection.class.isAssignableFrom(methodParameterClass) && List.class.isAssignableFrom(fieldClass)) {
                    try {
                        Class methodParameterGenericClass;
                        ParameterizedType methodParameterParameterizedType = (ParameterizedType)resultBuilderMethod.getGenericParameterTypes()[0];
                        if (methodParameterParameterizedType.getActualTypeArguments()[0] instanceof WildcardType) {
                            WildcardType methodParameterWildcardType = (WildcardType)methodParameterParameterizedType.getActualTypeArguments()[0];
                            methodParameterGenericClass = (Class)methodParameterWildcardType.getUpperBounds()[0];
                        } else {
                            methodParameterGenericClass = (Class)methodParameterParameterizedType.getActualTypeArguments()[0];
                        }
                        ParameterizedType fieldParameterizedType = (ParameterizedType)field.getGenericType();
                        Class fieldGenericClass = (Class)fieldParameterizedType.getActualTypeArguments()[0];
                        log.fine(field.getName() + " - Both lists. methodParameterGenericClass=" + methodParameterGenericClass + " and fieldGenericClass=" + fieldGenericClass);
                        if (field.get(modelObject) == null) continue;
                        if (methodParameterGenericClass.isAssignableFrom(fieldGenericClass)) {
                            log.fine(field.getName() + " - Both lists and types match. Calling builder method");
                            resultBuilderMethod.invoke(resultBuilder, field.get(modelObject));
                            continue;
                        }
                        log.fine(field.getName() + " - Both lists and RequestObject. RequestObjectBuilder.build");
                        List requestObjectsList = ((List)field.get(modelObject)).stream().map(modelFieldValue -> RequestObjectBuilder.build(methodParameterGenericClass, modelFieldValue)).collect(Collectors.toList());
                        resultBuilderMethod.invoke(resultBuilder, requestObjectsList);
                        continue;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        throw new IllegalArgumentException("This should not happen. Field is " + field.getName() + " in " + modelObject.getClass().getName(), e);
                    }
                }
                if (methodParameterClass.isAssignableFrom(fieldClass)) {
                    try {
                        log.fine(field.getName() + " - Types match. Calling builder method");
                        resultBuilderMethod.invoke(resultBuilder, field.get(modelObject));
                        continue;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        throw new IllegalArgumentException("This should not happen. Field is " + field.getName() + " in " + modelObject.getClass().getName(), e);
                    }
                }
                try {
                    log.fine(field.getName() + " - Types do not match. Calling RequestObjectBuilder.build");
                    resultBuilderMethod.invoke(resultBuilder, RequestObjectBuilder.build(methodParameterClass, field.get(modelObject)));
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new IllegalArgumentException("This should not happen. Field is " + field.getName() + " in " + modelObject.getClass().getName(), e);
                }
            }
            log.fine(field.getName() + " - Could not find method in builder");
        }
        try {
            Object result = resultBuilderClass.getMethod("build", new Class[0]).invoke(resultBuilder, new Object[0]);
            log.fine("Finished instance of " + requestObjectClass.getName());
            return (U)result;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("Could not find build method in the request object builder class " + resultBuilderClass.getName(), e);
        }
    }

    private static Method findBuilderMethod(Class<?> builderClass, String methodName) {
        List methods = Arrays.asList(builderClass.getDeclaredMethods()).stream().filter(method -> method.getName().equals(methodName) && method.getParameterCount() == 1).collect(Collectors.toList());
        if (methods.size() >= 2) {
            log.warning("Conflicting method name " + methodName + "in builder " + builderClass.getName());
            return null;
        }
        if (methods.isEmpty()) {
            return null;
        }
        return (Method)methods.get(0);
    }

    private static List<Field> getAllFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            fields.addAll(RequestObjectBuilder.getAllFields(type.getSuperclass()));
        }
        return fields;
    }
}

