/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public class RateLimit {
    @JsonProperty(value="limit")
    @NotNull
    private Integer limit;
    @JsonProperty(value="remaining")
    @NotNull
    private Integer remaining;
    @JsonProperty(value="reset")
    @JsonDeserialize(using=UnixTimestampDeserializer.class)
    @NotNull
    private Date reset;

    @NotNull
    public Integer getLimit() {
        return this.limit;
    }

    @NotNull
    public Integer getRemaining() {
        return this.remaining;
    }

    @NotNull
    public Date getReset() {
        return this.reset;
    }

    @JsonProperty(value="limit")
    public void setLimit(@NotNull Integer limit) {
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        this.limit = limit;
    }

    @JsonProperty(value="remaining")
    public void setRemaining(@NotNull Integer remaining) {
        if (remaining == null) {
            throw new NullPointerException("remaining is marked non-null but is null");
        }
        this.remaining = remaining;
    }

    @JsonProperty(value="reset")
    @JsonDeserialize(using=UnixTimestampDeserializer.class)
    public void setReset(@NotNull Date reset) {
        if (reset == null) {
            throw new NullPointerException("reset is marked non-null but is null");
        }
        this.reset = reset;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RateLimit)) {
            return false;
        }
        RateLimit other = (RateLimit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Integer this$remaining = this.getRemaining();
        Integer other$remaining = other.getRemaining();
        if (this$remaining == null ? other$remaining != null : !((Object)this$remaining).equals(other$remaining)) {
            return false;
        }
        Date this$reset = this.getReset();
        Date other$reset = other.getReset();
        return !(this$reset == null ? other$reset != null : !((Object)this$reset).equals(other$reset));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RateLimit;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Integer $remaining = this.getRemaining();
        result = result * 59 + ($remaining == null ? 43 : ((Object)$remaining).hashCode());
        Date $reset = this.getReset();
        result = result * 59 + ($reset == null ? 43 : ((Object)$reset).hashCode());
        return result;
    }

    public String toString() {
        return "RateLimit(limit=" + this.getLimit() + ", remaining=" + this.getRemaining() + ", reset=" + this.getReset() + ")";
    }

    public static class UnixTimestampDeserializer
    extends JsonDeserializer<Date> {
        public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String jsonString = (String)jsonParser.readValueAs(String.class);
            try {
                return new Date(Long.parseLong(jsonString) * 1000L);
            }
            catch (NumberFormatException e) {
                throw deserializationContext.instantiationException(Date.class, "Unparseable date for unix timestamp: " + jsonString);
            }
        }
    }
}

