/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.keychain.impl;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.Base64;
import io.getlime.security.powerauth.keychain.Keychain;
import io.getlime.security.powerauth.keychain.SymmetricKeyProvider;
import io.getlime.security.powerauth.keychain.impl.AesGcmImpl;
import io.getlime.security.powerauth.keychain.impl.KeychainValueEncoder;
import io.getlime.security.powerauth.keychain.impl.ReservedKeyImpl;
import io.getlime.security.powerauth.system.PA2Log;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.SecretKey;

@RequiresApi(api=23)
public class EncryptedKeychain
implements Keychain {
    @NonNull
    private final String identifier;
    @NonNull
    private final Context context;
    @NonNull
    private final SymmetricKeyProvider keyProvider;
    @NonNull
    private final KeychainValueEncoder valueEncoder;
    @RequiresApi(api=19)
    public static final String ENCRYPTED_KEYCHAIN_VERSION_KEY = "com.wultra.PowerAuthKeychain.IsEncrypted";
    @RequiresApi(api=19)
    public static final int ENCRYPTED_KEYCHAIN_VERSION = 1;

    public EncryptedKeychain(@NonNull Context context, @NonNull String identifier, @NonNull SymmetricKeyProvider secretKeyProvider) {
        this.identifier = identifier;
        this.context = context;
        this.keyProvider = secretKeyProvider;
        this.valueEncoder = new KeychainValueEncoder();
    }

    @Override
    @NonNull
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean isEncrypted() {
        return true;
    }

    @Override
    public boolean isReservedKey(@NonNull String key) {
        return ReservedKeyImpl.isReservedKey(key);
    }

    @Override
    public synchronized boolean contains(@NonNull String key) {
        return this.getRawValue(key) != null;
    }

    @Override
    public synchronized void remove(@NonNull String key) {
        ReservedKeyImpl.failOnReservedKey(key);
        this.getSharedPreferences().edit().remove(key).apply();
    }

    @Override
    public synchronized void removeAll() {
        this.getSharedPreferences().edit().clear().putInt(ENCRYPTED_KEYCHAIN_VERSION_KEY, 1).apply();
    }

    @Override
    @Nullable
    public synchronized byte[] getData(@NonNull String key) {
        byte[] encoded = this.getRawValue(key);
        if (encoded == null) {
            return null;
        }
        byte[] decoded = this.valueEncoder.decodeBytes(encoded);
        return (byte[])(decoded.length > 0 ? decoded : null);
    }

    @Override
    public synchronized void putData(@Nullable byte[] data, @NonNull String key) {
        this.setRawValue(key, data != null && data.length > 0 ? this.valueEncoder.encode(data) : null);
    }

    @Override
    @Nullable
    public synchronized String getString(@NonNull String key) {
        byte[] encoded = this.getRawValue(key);
        if (encoded == null) {
            return null;
        }
        return this.valueEncoder.decodeString(encoded);
    }

    @Override
    @NonNull
    public synchronized String getString(@NonNull String key, @NonNull String defaultValue) {
        byte[] encoded = this.getRawValue(key);
        if (encoded == null) {
            return defaultValue;
        }
        return this.valueEncoder.decodeString(encoded);
    }

    @Override
    public synchronized void putString(@Nullable String string2, @NonNull String key) {
        this.setRawValue(key, string2 != null ? this.valueEncoder.encode(string2) : null);
    }

    @Override
    @Nullable
    public synchronized Set<String> getStringSet(@NonNull String key) {
        byte[] encoded = this.getRawValue(key);
        if (encoded == null) {
            return null;
        }
        return this.valueEncoder.decodeStringSet(encoded);
    }

    @Override
    public synchronized void putStringSet(@Nullable Set<String> stringSet, @NonNull String key) {
        this.setRawValue(key, stringSet != null ? this.valueEncoder.encode(stringSet) : null);
    }

    @Override
    public synchronized boolean getBoolean(@NonNull String key, boolean defaultValue) {
        byte[] bytes = this.getRawValue(key);
        if (bytes == null) {
            return defaultValue;
        }
        return this.valueEncoder.decodeBoolean(bytes);
    }

    @Override
    public synchronized void putBoolean(boolean value, @NonNull String key) {
        this.setRawValue(key, this.valueEncoder.encode(value));
    }

    @Override
    public synchronized long getLong(@NonNull String key, long defaultValue) {
        byte[] bytes = this.getRawValue(key);
        if (bytes == null) {
            return defaultValue;
        }
        return this.valueEncoder.decodeLong(bytes);
    }

    @Override
    public synchronized void putLong(long value, @NonNull String key) {
        this.setRawValue(key, this.valueEncoder.encode(value));
    }

    @Override
    public float getFloat(@NonNull String key, float defaultValue) {
        byte[] bytes = this.getRawValue(key);
        if (bytes == null) {
            return defaultValue;
        }
        return this.valueEncoder.decodeFloat(bytes);
    }

    @Override
    public void putFloat(float value, @NonNull String key) {
        this.setRawValue(key, this.valueEncoder.encode(value));
    }

    @RequiresApi(api=19)
    public static boolean isEncryptedContentInSharedPreferences(@NonNull SharedPreferences preferences) {
        return 1 == preferences.getInt(ENCRYPTED_KEYCHAIN_VERSION_KEY, 0);
    }

    public static boolean verifyKeystoreEncryption(@NonNull Context context, @NonNull SymmetricKeyProvider keyProvider) {
        SecretKey secretKey = keyProvider.getOrCreateSecretKey(context, false);
        if (secretKey == null) {
            PA2Log.e("verifyKeystoreEncryption: Failed to acquire secret key.", new Object[0]);
            return false;
        }
        String identifier = "TestIdentifier";
        byte[] testData = new byte[0];
        byte[] encrypted = AesGcmImpl.encrypt(testData, secretKey, "TestIdentifier");
        if (encrypted == null) {
            PA2Log.e("verifyKeystoreEncryption: Empty data encryption failed.", new Object[0]);
            return false;
        }
        byte[] decrypted = AesGcmImpl.decrypt(encrypted, secretKey, "TestIdentifier");
        if (decrypted == null || !Arrays.equals(testData, decrypted)) {
            PA2Log.e("verifyKeystoreEncryption: Empty data decryption failed.", new Object[0]);
            return false;
        }
        testData = ENCRYPTED_KEYCHAIN_VERSION_KEY.getBytes(Charset.defaultCharset());
        encrypted = AesGcmImpl.encrypt(testData, secretKey, "TestIdentifier");
        if (encrypted == null) {
            PA2Log.e("verifyKeystoreEncryption: Non-empty data encryption failed.", new Object[0]);
            return false;
        }
        decrypted = AesGcmImpl.decrypt(encrypted, secretKey, "TestIdentifier");
        if (decrypted == null || !Arrays.equals(testData, decrypted)) {
            PA2Log.e("verifyKeystoreEncryption: Non-empty data decryption failed.", new Object[0]);
            return false;
        }
        return true;
    }

    public boolean importFromLegacyKeychain(@NonNull SharedPreferences preferences) {
        SecretKey encryptionKey = this.getMasterKey();
        if (encryptionKey == null) {
            return false;
        }
        HashMap encryptedContent = new HashMap();
        HashSet keysToRemove = new HashSet();
        for (Map.Entry entry : preferences.getAll().entrySet()) {
            byte[] encodedValue;
            Object value = entry.getValue();
            if (value instanceof String) {
                String string2 = (String)value;
                if (string2.isEmpty()) {
                    keysToRemove.add(entry.getKey());
                    continue;
                }
                byte[] decodedBytes = this.tryDecodeBase64Data(string2);
                encodedValue = decodedBytes != null ? this.valueEncoder.encode(decodedBytes) : this.valueEncoder.encode(string2);
            } else if (value instanceof Boolean) {
                encodedValue = this.valueEncoder.encode((Boolean)value);
            } else if (value instanceof Long) {
                encodedValue = this.valueEncoder.encode((Long)value);
            } else if (value instanceof Float) {
                encodedValue = this.valueEncoder.encode(((Float)value).floatValue());
            } else if (value instanceof Set) {
                Set stringSet = (Set)value;
                encodedValue = this.valueEncoder.encode(stringSet);
            } else {
                PA2Log.e("EncryptedKeychain: " + this.identifier + ": Removing unsupported value from key: " + (String)entry.getKey(), new Object[0]);
                keysToRemove.add(entry.getKey());
                continue;
            }
            byte[] encryptedValue = AesGcmImpl.encrypt(encodedValue, encryptionKey, this.identifier);
            if (encryptedValue == null) {
                PA2Log.e("EncryptedKeychain: " + this.identifier + ": Failed to import value from key: " + (String)entry.getKey(), new Object[0]);
                return false;
            }
            encryptedContent.put(entry.getKey(), Base64.encodeToString((byte[])encryptedValue, (int)2));
        }
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        for (Map.Entry entry : encryptedContent.entrySet()) {
            editor.putString((String)entry.getKey(), (String)entry.getValue());
        }
        for (String key : keysToRemove) {
            editor.remove(key);
        }
        editor.putInt(ENCRYPTED_KEYCHAIN_VERSION_KEY, 1);
        editor.apply();
        return true;
    }

    @Nullable
    private byte[] tryDecodeBase64Data(@NonNull String string2) {
        try {
            byte[] decodedBytes = Base64.decode((String)string2, (int)0);
            if (Base64.encodeToString((byte[])decodedBytes, (int)0).trim().equals(string2.trim())) {
                return decodedBytes;
            }
            return null;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    @NonNull
    private SharedPreferences getSharedPreferences() {
        return this.context.getSharedPreferences(this.identifier, 0);
    }

    @Nullable
    private byte[] getRawValue(@NonNull String key) {
        ReservedKeyImpl.failOnReservedKey(key);
        String encodedValue = this.getSharedPreferences().getString(key, null);
        if (encodedValue == null) {
            return null;
        }
        byte[] encryptedBytes = Base64.decode((String)encodedValue, (int)2);
        if (encryptedBytes.length == 0) {
            return null;
        }
        SecretKey secretKey = this.getMasterKey();
        if (secretKey == null) {
            return null;
        }
        return AesGcmImpl.decrypt(encryptedBytes, secretKey, this.identifier);
    }

    private void setRawValue(@NonNull String key, @Nullable byte[] value) {
        String encryptedString;
        ReservedKeyImpl.failOnReservedKey(key);
        SecretKey secretKey = this.getMasterKey();
        if (secretKey == null) {
            return;
        }
        if (value == null) {
            encryptedString = null;
        } else {
            byte[] encryptedValue = AesGcmImpl.encrypt(value, secretKey, this.identifier);
            if (encryptedValue == null) {
                return;
            }
            encryptedString = Base64.encodeToString((byte[])encryptedValue, (int)2);
        }
        this.getSharedPreferences().edit().putString(key, encryptedString).apply();
    }

    @Nullable
    private SecretKey getMasterKey() {
        SecretKey masterSecretKey = this.keyProvider.getOrCreateSecretKey(this.context, false);
        if (masterSecretKey == null) {
            PA2Log.e("EncryptedKeychain: " + this.identifier + ": Unable to acquire master key.", new Object[0]);
        }
        return masterSecretKey;
    }
}

