/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.keychain;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.security.keystore.KeyInfo;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import io.getlime.security.powerauth.exception.PowerAuthErrorException;
import io.getlime.security.powerauth.keychain.Keychain;
import io.getlime.security.powerauth.keychain.SymmetricKeyProvider;
import io.getlime.security.powerauth.keychain.impl.EncryptedKeychain;
import io.getlime.security.powerauth.keychain.impl.LegacyKeychain;
import io.getlime.security.powerauth.system.PA2Log;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;

public class KeychainFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static Keychain getKeychain(@NonNull Context context, @NonNull String identifier, int minimumKeychainProtection) throws PowerAuthErrorException {
        Class<SharedData> clazz = SharedData.class;
        synchronized (SharedData.class) {
            SharedData sharedData = KeychainFactory.getSharedData();
            Context appContext = context.getApplicationContext();
            if (minimumKeychainProtection > sharedData.getKeychainProtection(context)) {
                throw new PowerAuthErrorException(21, "Device doesn't support required level of keychain protection.");
            }
            Keychain keychain = sharedData.getKeychainMap().get(identifier);
            if (keychain == null) {
                keychain = KeychainFactory.createKeychain(appContext, sharedData, identifier);
                PA2Log.d("KeychainFactory: " + identifier + ": Created " + (keychain.isEncrypted() ? "encrypted keychain." : "legacy keychain."), new Object[0]);
                sharedData.getKeychainMap().put(identifier, keychain);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return keychain;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getKeychainProtectionSupportedOnDevice(@NonNull Context context) {
        Class<SharedData> clazz = SharedData.class;
        synchronized (SharedData.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return KeychainFactory.getSharedData().getKeychainProtection(context);
        }
    }

    @NonNull
    private static SharedData getSharedData() {
        return SharedData.INSTANCE;
    }

    @NonNull
    private static Keychain createKeychain(@NonNull Context context, @NonNull SharedData sharedData, @NonNull String identifier) {
        SymmetricKeyProvider masterKeyProvider;
        SharedPreferences preferences = context.getSharedPreferences(identifier, 0);
        boolean isAlreadyEncrypted = EncryptedKeychain.isEncryptedContentInSharedPreferences(preferences);
        int keychainProtection = sharedData.getKeychainProtection(context);
        if (Build.VERSION.SDK_INT >= 23 && keychainProtection != 1 && (masterKeyProvider = sharedData.getMasterEncryptionKeyProvider()) != null) {
            EncryptedKeychain encryptedKeychain = new EncryptedKeychain(context, identifier, masterKeyProvider);
            if (isAlreadyEncrypted || encryptedKeychain.importFromLegacyKeychain(preferences)) {
                return encryptedKeychain;
            }
        }
        LegacyKeychain keychain = new LegacyKeychain(context, identifier);
        if (isAlreadyEncrypted) {
            PA2Log.e("KeychainFactory: " + identifier + ": The content was previously encrypted but the encryption is no longer available.", new Object[0]);
            keychain.removeAll();
        }
        return keychain;
    }

    private static class SharedData {
        private static final SharedData INSTANCE = new SharedData();
        private Map<String, Keychain> keychainMap = new HashMap<String, Keychain>();
        private SymmetricKeyProvider masterEncryptionKeyProvider;
        private int keychainProtection;
        private static final String MASTER_KEY_ALIAS = "com.wultra.PowerAuthKeychain.MasterKey";
        private static final int MASTER_KEY_SIZE = 256;

        private SharedData() {
        }

        Map<String, Keychain> getKeychainMap() {
            return this.keychainMap;
        }

        @Nullable
        @RequiresApi(api=23)
        SymmetricKeyProvider getMasterEncryptionKeyProvider() {
            if (this.masterEncryptionKeyProvider == null) {
                this.masterEncryptionKeyProvider = SymmetricKeyProvider.getAesGcmKeyProvider(MASTER_KEY_ALIAS, 256, true, null);
                if (this.masterEncryptionKeyProvider == null) {
                    PA2Log.e("KeychainFactory: Unable to acquire common master key provider for EncryptedKeychain.", new Object[0]);
                }
            }
            return this.masterEncryptionKeyProvider;
        }

        int getKeychainProtection(@NonNull Context context) {
            if (this.keychainProtection == 0) {
                if (Build.VERSION.SDK_INT >= 23) {
                    KeyInfo secretKeyInfo;
                    SymmetricKeyProvider keyProvider = this.getMasterEncryptionKeyProvider();
                    SecretKey secretKey = keyProvider != null ? keyProvider.getOrCreateSecretKey(context, false) : null;
                    KeyInfo keyInfo = secretKeyInfo = keyProvider != null ? keyProvider.getSecretKeyInfo(context) : null;
                    if (secretKey != null && secretKeyInfo != null && EncryptedKeychain.verifyKeystoreEncryption(context, keyProvider)) {
                        this.keychainProtection = secretKeyInfo.isInsideSecureHardware() ? (Build.VERSION.SDK_INT >= 28 && context.getPackageManager().hasSystemFeature("android.hardware.strongbox_keystore") ? 4 : 3) : 2;
                    }
                }
                if (this.keychainProtection == 0) {
                    this.keychainProtection = 1;
                }
            }
            return this.keychainProtection;
        }
    }
}

