/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.biometry.impl;

import android.os.SystemClock;
import android.support.annotation.NonNull;
import io.getlime.security.powerauth.biometry.BiometricAuthenticationRequest;
import io.getlime.security.powerauth.biometry.BiometricDialogResources;
import io.getlime.security.powerauth.biometry.impl.BiometricResultDispatcher;

public class PrivateRequestData {
    @NonNull
    private final BiometricAuthenticationRequest request;
    @NonNull
    private final BiometricResultDispatcher dispatcher;
    @NonNull
    private final BiometricDialogResources resources;
    private final long creationTime;

    public PrivateRequestData(@NonNull BiometricAuthenticationRequest request, @NonNull BiometricResultDispatcher dispatcher, @NonNull BiometricDialogResources resources) {
        this.request = request;
        this.dispatcher = dispatcher;
        this.resources = resources;
        this.creationTime = SystemClock.elapsedRealtime();
    }

    @NonNull
    public BiometricAuthenticationRequest getRequest() {
        return this.request;
    }

    @NonNull
    public BiometricResultDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @NonNull
    public BiometricDialogResources getResources() {
        return this.resources;
    }

    public long getElapsedTime() {
        return SystemClock.elapsedRealtime() - this.creationTime;
    }
}

