/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.sdk;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Base64;
import io.getlime.security.powerauth.exception.PowerAuthErrorException;
import io.getlime.security.powerauth.keychain.Keychain;
import io.getlime.security.powerauth.networking.client.HttpClient;
import io.getlime.security.powerauth.networking.endpoints.CreateTokenEndpoint;
import io.getlime.security.powerauth.networking.endpoints.RemoveTokenEndpoint;
import io.getlime.security.powerauth.networking.interfaces.ICancelable;
import io.getlime.security.powerauth.networking.interfaces.INetworkResponseListener;
import io.getlime.security.powerauth.networking.model.entity.TokenResponsePayload;
import io.getlime.security.powerauth.networking.model.request.TokenRemoveRequest;
import io.getlime.security.powerauth.networking.response.IGetTokenListener;
import io.getlime.security.powerauth.networking.response.IRemoveTokenListener;
import io.getlime.security.powerauth.sdk.PowerAuthAuthentication;
import io.getlime.security.powerauth.sdk.PowerAuthSDK;
import io.getlime.security.powerauth.sdk.PowerAuthToken;
import io.getlime.security.powerauth.sdk.impl.PowerAuthPrivateTokenData;
import java.util.HashMap;
import java.util.HashSet;

public class PowerAuthTokenStore {
    private final PowerAuthSDK sdk;
    private final Keychain keychain;
    private final HttpClient httpClient;
    private final HashMap<String, PowerAuthPrivateTokenData> localTokens;
    private final String keychainKeyPrefix;
    private static final String TOKENS_KEY_PREFIX = "powerAuthToken";
    private static final String TOKENS_INDEX_ENTRY = "$$index$$";

    public PowerAuthTokenStore(@NonNull PowerAuthSDK sdk, @NonNull Keychain keychain, @NonNull HttpClient httpClient) {
        this.sdk = sdk;
        this.keychain = keychain;
        this.httpClient = httpClient;
        this.localTokens = new HashMap();
        this.keychainKeyPrefix = "powerAuthToken__" + sdk.getConfiguration().getInstanceId() + "__";
    }

    public synchronized boolean canRequestForAccessToken() {
        return this.sdk != null && this.sdk.hasValidActivation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ICancelable requestAccessToken(final @NonNull Context context, final @NonNull String tokenName, @NonNull PowerAuthAuthentication authentication, final @NonNull IGetTokenListener listener) {
        PowerAuthErrorException error = null;
        PowerAuthPrivateTokenData tokenData = null;
        PowerAuthTokenStore powerAuthTokenStore = this;
        synchronized (powerAuthTokenStore) {
            if (this.canRequestForAccessToken()) {
                tokenData = this.getTokenData(context, tokenName);
            } else {
                error = new PowerAuthErrorException(5);
            }
        }
        if (error != null) {
            final PowerAuthErrorException err = error;
            this.sdk.dispatchCallback(new Runnable(){

                @Override
                public void run() {
                    listener.onGetTokenFailed(err);
                }
            });
            return null;
        }
        if (tokenData != null) {
            final PowerAuthToken token = new PowerAuthToken(this, tokenData);
            this.sdk.dispatchCallback(new Runnable(){

                @Override
                public void run() {
                    listener.onGetTokenSucceeded(token);
                }
            });
            return null;
        }
        return this.httpClient.post(null, new CreateTokenEndpoint(), this.sdk.getCryptoHelper(context), authentication, new INetworkResponseListener<TokenResponsePayload>(){

            @Override
            public void onNetworkResponse(TokenResponsePayload response) {
                byte[] tokenSecretBytes = Base64.decode((String)response.getTokenSecret(), (int)2);
                PowerAuthPrivateTokenData newTokenData = new PowerAuthPrivateTokenData(tokenName, response.getTokenId(), tokenSecretBytes);
                if (newTokenData.hasValidData()) {
                    PowerAuthTokenStore.this.storeTokenData(context, newTokenData);
                    listener.onGetTokenSucceeded(new PowerAuthToken(PowerAuthTokenStore.this, newTokenData));
                } else {
                    listener.onGetTokenFailed(new PowerAuthErrorException(14));
                }
            }

            @Override
            public void onNetworkError(Throwable t) {
                listener.onGetTokenFailed(t);
            }

            @Override
            public void onCancel() {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ICancelable removeAccessToken(final @NonNull Context context, final @NonNull String tokenName, final @NonNull IRemoveTokenListener listener) {
        PowerAuthPrivateTokenData tokenData;
        PowerAuthErrorException error = null;
        PowerAuthTokenStore powerAuthTokenStore = this;
        synchronized (powerAuthTokenStore) {
            tokenData = this.getTokenData(context, tokenName);
            if (tokenData == null) {
                error = new PowerAuthErrorException(13);
            }
        }
        if (error != null) {
            final PowerAuthErrorException err = error;
            this.sdk.dispatchCallback(new Runnable(){

                @Override
                public void run() {
                    listener.onRemoveTokenFailed(err);
                }
            });
            return null;
        }
        TokenRemoveRequest request = new TokenRemoveRequest();
        request.setTokenId(tokenData.identifier);
        PowerAuthAuthentication authentication = new PowerAuthAuthentication();
        authentication.usePossession = true;
        return this.httpClient.post(request, new RemoveTokenEndpoint(), this.sdk.getCryptoHelper(context), authentication, new INetworkResponseListener<Void>(){

            @Override
            public void onNetworkResponse(Void aVoid) {
                PowerAuthTokenStore.this.removeLocalToken(context, tokenName);
                listener.onRemoveTokenSucceeded();
            }

            @Override
            public void onNetworkError(Throwable t) {
                listener.onRemoveTokenFailed(t);
            }

            @Override
            public void onCancel() {
            }
        });
    }

    public synchronized boolean hasLocalToken(@NonNull Context context, @NonNull String tokenName) {
        return this.getTokenData(context, tokenName) != null;
    }

    @Nullable
    public synchronized PowerAuthToken getLocalToken(@NonNull Context context, @NonNull String tokenName) {
        PowerAuthPrivateTokenData tokenData = this.getTokenData(context, tokenName);
        if (tokenData != null) {
            return new PowerAuthToken(this, tokenData);
        }
        return null;
    }

    public synchronized void removeLocalToken(@NonNull Context context, @NonNull String tokenName) {
        String identifier = this.getLocalIdentifier(tokenName);
        this.localTokens.remove(identifier);
        this.keychain.remove(identifier);
        HashSet<String> allIdentifiers = this.loadTokensIndex(context);
        allIdentifiers.remove(identifier);
        this.saveTokensIndex(context, allIdentifiers);
    }

    public synchronized void removeAllLocalTokens(@NonNull Context context) {
        this.clearTokensIndex(context);
        this.localTokens.clear();
    }

    @Nullable
    private PowerAuthPrivateTokenData getTokenData(@NonNull Context context, @NonNull String tokenName) {
        byte[] tokenBytes;
        String identifier = this.getLocalIdentifier(tokenName);
        PowerAuthPrivateTokenData tokenData = this.localTokens.get(identifier);
        if (tokenData == null && (tokenBytes = this.keychain.getData(identifier)) != null && (tokenData = PowerAuthPrivateTokenData.deserializeWithData(tokenBytes)) != null) {
            this.localTokens.put(identifier, tokenData);
        }
        return tokenData;
    }

    private synchronized void storeTokenData(@NonNull Context context, @NonNull PowerAuthPrivateTokenData tokenData) {
        if (!this.canRequestForAccessToken()) {
            return;
        }
        String identifier = this.getLocalIdentifier(tokenData.name);
        this.localTokens.put(identifier, tokenData);
        this.keychain.putData(tokenData.getSerializedData(), identifier);
        HashSet<String> index = this.loadTokensIndex(context);
        index.add(identifier);
        this.saveTokensIndex(context, index);
    }

    @NonNull
    private String getLocalIdentifier(@NonNull String tokenName) {
        return this.keychainKeyPrefix + Base64.encodeToString((byte[])tokenName.getBytes(), (int)2);
    }

    private boolean isValidLocalIdentifier(@NonNull String identifier) {
        return identifier.startsWith(this.keychainKeyPrefix);
    }

    private String getIndexKey() {
        return this.keychainKeyPrefix + TOKENS_INDEX_ENTRY;
    }

    private void saveTokensIndex(@NonNull Context context, @NonNull HashSet<String> index) {
        String joinedIdentifiers = TextUtils.join((CharSequence)"\n", (Object[])index.toArray());
        this.keychain.putString(joinedIdentifiers, this.getIndexKey());
    }

    private HashSet<String> loadTokensIndex(@NonNull Context context) {
        HashSet<String> index = new HashSet<String>();
        String joinedIdentifiers = this.keychain.getString(this.getIndexKey());
        if (joinedIdentifiers != null) {
            String[] tokenIdentifiers;
            for (String identifier : tokenIdentifiers = joinedIdentifiers.split("\\n")) {
                if (!this.isValidLocalIdentifier(identifier)) continue;
                index.add(identifier);
            }
        }
        return index;
    }

    private void clearTokensIndex(@NonNull Context context) {
        HashSet<String> identifiers = this.loadTokensIndex(context);
        for (String id2 : identifiers) {
            this.keychain.remove(id2);
        }
        this.keychain.remove(this.getIndexKey());
    }
}

