/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.biometry.impl;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.Pair;
import io.getlime.security.powerauth.R;
import io.getlime.security.powerauth.biometry.BiometricDialogResources;
import io.getlime.security.powerauth.exception.PowerAuthErrorException;

public class BiometricHelper {
    @NonNull
    public static PowerAuthErrorException getExceptionForBiometricStatus(int status) {
        switch (status) {
            case 2: {
                return new PowerAuthErrorException(19, "Biometric data is not enrolled on the device.");
            }
            case 1: {
                return new PowerAuthErrorException(18, "Biometry is not supported on the device.");
            }
            case 3: {
                return new PowerAuthErrorException(19, "Biometry is not available. Try again later.");
            }
            case 0: {
                throw new IllegalArgumentException("Cannot get exception for success status.");
            }
        }
        throw new IllegalArgumentException("Unknown status.");
    }

    @NonNull
    public static Pair<Integer, Integer> getErrorDialogStringsForBiometricStatus(int status, @NonNull BiometricDialogResources resources) {
        int errorDescription;
        int errorTitle;
        if (status == 2) {
            errorTitle = resources.strings.errorEnrollFingerprintTitle;
            errorDescription = resources.strings.errorEnrollFingerprintDescription;
        } else if (status == 1) {
            errorTitle = resources.strings.errorNoFingerprintScannerTitle;
            errorDescription = resources.strings.errorNoFingerprintScannerDescription;
        } else if (status == 3) {
            errorTitle = resources.strings.errorFingerprintDisabledTitle;
            errorDescription = resources.strings.errorFingerprintDisabledDescription;
        } else {
            errorTitle = resources.strings.errorFingerprintDisabledTitle;
            errorDescription = resources.strings.errorFingerprintDisabledDescription;
        }
        return Pair.create((Object)errorTitle, (Object)errorDescription);
    }

    public static boolean shouldFallbackToFingerprintManager(@NonNull Context context) {
        if (Build.VERSION.SDK_INT != 28) {
            return false;
        }
        if (!BiometricHelper.isVendorInFallbackList(context)) {
            return false;
        }
        return BiometricHelper.isModelInPrefixList(context.getResources().getStringArray(R.array.crypto_fingerprint_fallback_prefixes));
    }

    public static boolean shouldHideFingerprintDialog(@NonNull Context context) {
        if (Build.VERSION.SDK_INT != 28) {
            return false;
        }
        if (!BiometricHelper.isVendorInFallbackList(context)) {
            return false;
        }
        return BiometricHelper.isModelInPrefixList(context.getResources().getStringArray(R.array.hide_fingerprint_instantly_prefixes));
    }

    private static boolean isVendorInFallbackList(@NonNull Context context) {
        String[] vendorNames = context.getResources().getStringArray(R.array.crypto_fingerprint_fallback_vendors);
        String vendor = Build.MANUFACTURER;
        if (vendor == null) {
            return false;
        }
        for (String vendorName : vendorNames) {
            if (!vendor.equalsIgnoreCase(vendorName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isModelInPrefixList(String[] modelPrefixes) {
        String model = Build.MODEL;
        if (model == null) {
            return false;
        }
        for (String modelPrefix : modelPrefixes) {
            if (!model.startsWith(modelPrefix)) continue;
            return true;
        }
        return false;
    }
}

