/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.sdk;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.getlime.security.powerauth.networking.response.IFetchKeysStrategy;
import io.getlime.security.powerauth.sdk.impl.DefaultFetchKeysStrategy;
import java.util.Arrays;

public class PowerAuthConfiguration {
    @NonNull
    private final String instanceId;
    @NonNull
    private final String baseEndpointUrl;
    @NonNull
    private final String appKey;
    @NonNull
    private final String appSecret;
    @NonNull
    private final String masterServerPublicKey;
    @Nullable
    private final byte[] externalEncryptionKey;
    @NonNull
    private final IFetchKeysStrategy fetchKeysStrategy;
    private final boolean disableAutomaticProtocolUpgrade;
    public static final String DEFAULT_INSTANCE_ID = "defaultPowerAuthInstance";

    @NonNull
    public String getInstanceId() {
        return this.instanceId;
    }

    @NonNull
    public String getBaseEndpointUrl() {
        return this.baseEndpointUrl;
    }

    @NonNull
    public String getAppKey() {
        return this.appKey;
    }

    @NonNull
    public String getAppSecret() {
        return this.appSecret;
    }

    @NonNull
    public String getMasterServerPublicKey() {
        return this.masterServerPublicKey;
    }

    @Nullable
    public byte[] getExternalEncryptionKey() {
        return this.externalEncryptionKey;
    }

    @NonNull
    public IFetchKeysStrategy getFetchKeysStrategy() {
        return this.fetchKeysStrategy;
    }

    public boolean isAutomaticProtocolUpgradeDisabled() {
        return this.disableAutomaticProtocolUpgrade;
    }

    public boolean validateConfiguration() {
        return this.externalEncryptionKey == null || this.externalEncryptionKey.length == 16;
    }

    private PowerAuthConfiguration(@NonNull String instanceId, @NonNull String baseEndpointUrl, @NonNull String appKey, @NonNull String appSecret, @NonNull String masterServerPublicKey, @Nullable byte[] externalEncryptionKey, @NonNull IFetchKeysStrategy fetchKeysStrategy, boolean disableAutomaticProtocolUpgrade) {
        this.instanceId = instanceId;
        this.baseEndpointUrl = baseEndpointUrl;
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.masterServerPublicKey = masterServerPublicKey;
        this.externalEncryptionKey = externalEncryptionKey;
        this.fetchKeysStrategy = fetchKeysStrategy;
        this.disableAutomaticProtocolUpgrade = disableAutomaticProtocolUpgrade;
    }

    public static class Builder {
        @NonNull
        private final String baseEndpointUrl;
        @NonNull
        private final String appKey;
        @NonNull
        private final String appSecret;
        @NonNull
        private final String masterServerPublicKey;
        private String instanceId;
        private IFetchKeysStrategy fetchKeysStrategy = null;
        private byte[] externalEncryptionKey = null;
        private boolean disableAutomaticProtocolUpgrade = false;

        public Builder(@Nullable String instanceId, @NonNull String baseEndpointUrl, @NonNull String appKey, @NonNull String appSecret, @NonNull String masterServerPublicKey) {
            this.instanceId = instanceId;
            this.appKey = appKey;
            this.appSecret = appSecret;
            this.masterServerPublicKey = masterServerPublicKey;
            this.baseEndpointUrl = baseEndpointUrl.endsWith("/") ? baseEndpointUrl.substring(0, baseEndpointUrl.length() - 1) : baseEndpointUrl;
        }

        @NonNull
        public Builder instanceId(@NonNull String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        @NonNull
        public Builder fetchKeysStrategy(@NonNull IFetchKeysStrategy fetchKeysStrategy) {
            this.fetchKeysStrategy = fetchKeysStrategy;
            return this;
        }

        @NonNull
        public Builder externalEncryptionKey(@NonNull byte[] externalEncryptionKey) {
            this.externalEncryptionKey = externalEncryptionKey;
            return this;
        }

        @NonNull
        public Builder disableAutomaticProtocolUpgrade() {
            this.disableAutomaticProtocolUpgrade = true;
            return this;
        }

        @NonNull
        public PowerAuthConfiguration build() {
            return new PowerAuthConfiguration(this.instanceId != null ? this.instanceId : PowerAuthConfiguration.DEFAULT_INSTANCE_ID, this.baseEndpointUrl, this.appKey, this.appSecret, this.masterServerPublicKey, this.externalEncryptionKey != null ? Arrays.copyOf(this.externalEncryptionKey, this.externalEncryptionKey.length) : null, this.fetchKeysStrategy != null ? this.fetchKeysStrategy : new DefaultFetchKeysStrategy(), this.disableAutomaticProtocolUpgrade);
        }
    }
}

