/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.sdk;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.getlime.security.powerauth.exception.PowerAuthErrorException;
import io.getlime.security.powerauth.networking.model.entity.ActivationType;
import io.getlime.security.powerauth.util.otp.Otp;
import io.getlime.security.powerauth.util.otp.OtpUtil;
import java.util.HashMap;
import java.util.Map;

public class PowerAuthActivation {
    @NonNull
    final ActivationType activationType;
    @NonNull
    final Map<String, String> identityAttributes;
    @Nullable
    final String additionalActivationOtp;
    @Nullable
    final String activationName;
    @Nullable
    final String extras;
    @Nullable
    final Map<String, Object> customAttributes;
    @Nullable
    final Otp activationCode;

    private PowerAuthActivation(@NonNull ActivationType activationType, @NonNull Map<String, String> identityAttributes, @Nullable String additionalActivationOtp, @Nullable String activationName, @Nullable String extras, @Nullable Map<String, Object> customAttributes, @Nullable Otp activationCode) {
        this.activationType = activationType;
        this.identityAttributes = identityAttributes;
        this.additionalActivationOtp = additionalActivationOtp;
        this.activationName = activationName;
        this.extras = extras;
        this.customAttributes = customAttributes;
        this.activationCode = activationCode;
    }

    public static class Builder {
        @NonNull
        private final ActivationType activationType;
        @NonNull
        private final Map<String, String> identityAttributes;
        @Nullable
        private final String activationName;
        @Nullable
        private final Otp activationCode;
        @Nullable
        private String extras;
        @Nullable
        private Map<String, Object> customAttributes;
        @Nullable
        private String additionalActivationOtp;

        private Builder(@NonNull ActivationType activationType, @NonNull Map<String, String> identityAttributes, @Nullable String activationName, @Nullable Otp activationCode) {
            this.activationType = activationType;
            this.identityAttributes = identityAttributes;
            this.activationName = activationName;
            this.activationCode = activationCode;
        }

        @NonNull
        public static Builder activation(@NonNull String activationCode, @Nullable String activationName) throws PowerAuthErrorException {
            Otp otp = OtpUtil.parseFromActivationCode(activationCode);
            if (otp == null) {
                throw new PowerAuthErrorException(12, "Invalid activation code");
            }
            HashMap<String, String> identityAttributes = new HashMap<String, String>(1);
            identityAttributes.put("code", otp.activationCode);
            return new Builder(ActivationType.CODE, identityAttributes, activationName, otp);
        }

        @NonNull
        public static Builder customActivation(@NonNull Map<String, String> identityAttributes, @Nullable String activationName) throws PowerAuthErrorException {
            if (identityAttributes.isEmpty()) {
                throw new PowerAuthErrorException(12, "Empty identity attributes");
            }
            return new Builder(ActivationType.CUSTOM, identityAttributes, activationName, null);
        }

        @NonNull
        public static Builder recoveryActivation(@NonNull String recoveryCode, @NonNull String puk, @Nullable String activationName) throws PowerAuthErrorException {
            Otp otp = OtpUtil.parseFromRecoveryCode(recoveryCode);
            if (otp == null) {
                throw new PowerAuthErrorException(12, "Invalid recovery code");
            }
            if (!OtpUtil.validateRecoveryPuk(puk)) {
                throw new PowerAuthErrorException(12, "Invalid recovery PUK");
            }
            HashMap<String, String> identityAttributes = new HashMap<String, String>(2);
            identityAttributes.put("recoveryCode", otp.activationCode);
            identityAttributes.put("puk", puk);
            return new Builder(ActivationType.RECOVERY, identityAttributes, activationName, null);
        }

        @NonNull
        public Builder setExtras(@Nullable String extras) {
            this.extras = extras;
            return this;
        }

        @NonNull
        public Builder setCustomAttributes(@Nullable Map<String, Object> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        @NonNull
        public Builder setAdditionalActivationOtp(@NonNull String additionalActivationOtp) {
            this.additionalActivationOtp = additionalActivationOtp;
            return this;
        }

        public PowerAuthActivation build() throws PowerAuthErrorException {
            if (this.additionalActivationOtp != null) {
                if (this.additionalActivationOtp.isEmpty()) {
                    throw new PowerAuthErrorException(4, "Additional activation OTP is empty");
                }
                if (this.activationType != ActivationType.CODE) {
                    throw new PowerAuthErrorException(4, "Only regular activation can be used with additional activation OTP");
                }
            }
            return new PowerAuthActivation(this.activationType, this.identityAttributes, this.additionalActivationOtp, this.activationName, this.extras, this.customAttributes, this.activationCode);
        }
    }
}

