/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.keychain.impl;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.getlime.security.powerauth.system.PA2Log;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;

public class AesGcmImpl {
    public static final String AES_GCM_NO_PADDING = "AES/GCM/NoPadding";
    public static final int IV_SIZE_IN_BYTES = 12;
    public static final int TAG_SIZE_IN_BYTES = 16;

    @Nullable
    public static byte[] encrypt(@NonNull byte[] plaintext, @NonNull SecretKey key, @NonNull String identifier) {
        try {
            if (plaintext.length > 2147483619) {
                PA2Log.e("AesGcmImpl: " + identifier + ": Plaintext is too long.", new Object[0]);
                return null;
            }
            byte[] ciphertext = new byte[12 + plaintext.length + 16];
            byte[] aad = identifier.getBytes(Charset.defaultCharset());
            Cipher cipher = Cipher.getInstance(AES_GCM_NO_PADDING);
            cipher.init(1, key);
            cipher.updateAAD(aad);
            cipher.doFinal(plaintext, 0, plaintext.length, ciphertext, 12);
            System.arraycopy(cipher.getIV(), 0, ciphertext, 0, 12);
            return ciphertext;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException | ShortBufferException e) {
            PA2Log.e("AesGcmImpl: " + identifier + ": Failed to encrypt keychain value. Exception: " + e.getMessage(), new Object[0]);
            return null;
        }
    }

    @Nullable
    public static byte[] decrypt(@NonNull byte[] ciphertext, @NonNull SecretKey key, @NonNull String identifier) {
        try {
            if (ciphertext.length < 28) {
                PA2Log.e("AesGcmImpl: " + identifier + ": Ciphertext is too short.", new Object[0]);
                return null;
            }
            byte[] aad = identifier.getBytes(Charset.defaultCharset());
            GCMParameterSpec spec = new GCMParameterSpec(128, ciphertext, 0, 12);
            Cipher cipher = Cipher.getInstance(AES_GCM_NO_PADDING);
            cipher.init(2, (Key)key, spec);
            cipher.updateAAD(aad);
            return cipher.doFinal(ciphertext, 12, ciphertext.length - 12);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            PA2Log.e("AesGcmImpl: " + identifier + ": Failed to decrypt keychain value. Exception: " + e.getMessage(), new Object[0]);
            return null;
        }
    }
}

