/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.ecies;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

public class EciesMetadata {
    @NonNull
    private final String applicationKey;
    @Nullable
    private final String activationIdentifier;

    public EciesMetadata(@NonNull String applicationKey, @Nullable String activationIdentifier) {
        this.applicationKey = applicationKey;
        this.activationIdentifier = activationIdentifier;
    }

    @NonNull
    public String getActivationKey() {
        return this.applicationKey;
    }

    @Nullable
    public String getActivationIdentifier() {
        return this.activationIdentifier;
    }

    @NonNull
    public String getHttpHeaderKey() {
        return "X-PowerAuth-Encryption";
    }

    @NonNull
    public String getHttpHeaderValue() {
        String result = "PowerAuth version=\"3.1\" application_key=\"" + this.applicationKey + "\"";
        if (this.activationIdentifier != null) {
            return result + " activation_id=\"" + this.activationIdentifier + "\"";
        }
        return result;
    }
}

